/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.sgp4v;

import com.lavadip.skeye.Vector2d;
import com.lavadip.skeye.Vector3d;
import com.lavadip.skeye.astro.sgp4v.ElsetRec;
import com.lavadip.skeye.astro.sgp4v.SatElset;
import com.lavadip.skeye.astro.sgp4v.SatElsetException;
import com.lavadip.skeye.astro.sgp4v.Sgp4Data;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public final class Sgp4Unit {
    public static final TimeZone GMT_TZ = TimeZone.getTimeZone("GMT");
    private static final double pi = Math.PI;
    private static final double twopi = Math.PI * 2;
    private static final double rad = 57.2957795130823;
    private static final boolean HELP = false;
    private static final double SMALL_VAL = 1.5E-12;
    private double ao = 0.0;
    private double argpm = 0.0;
    private double cnodm = 0.0;
    private double con42 = 0.0;
    private double cosim = 0.0;
    private double sinim = 0.0;
    private double cosomm = 0.0;
    private double sinomm = 0.0;
    private double cosio = 0.0;
    private double cosio2 = 0.0;
    private double day = 0.0;
    private double dndt = 0.0;
    private double eccsq = 0.0;
    private double em = 0.0;
    private double emsq = 0.0;
    private double gam = 0.0;
    private double rtemsq = 0.0;
    private double inclm = 0.0;
    private double mm = 0.0;
    private double omegam = 0.0;
    private double omeosq = 0.0;
    private double posq = 0.0;
    private double rp = 0.0;
    private double rteosq = 0.0;
    private double s1 = 0.0;
    private double s2 = 0.0;
    private double s3 = 0.0;
    private double s4 = 0.0;
    private double s5 = 0.0;
    private double s6 = 0.0;
    private double s7 = 0.0;
    private final ElsetRec satrec = new ElsetRec();
    private double sinio = 0.0;
    private double snodm = 0.0;
    private double ss1 = 0.0;
    private double ss2 = 0.0;
    private double ss3 = 0.0;
    private double ss4 = 0.0;
    private double ss5 = 0.0;
    private double ss6 = 0.0;
    private double ss7 = 0.0;
    private double sz1 = 0.0;
    private double sz2 = 0.0;
    private double sz3 = 0.0;
    private double sz11 = 0.0;
    private double sz12 = 0.0;
    private double sz13 = 0.0;
    private double sz21 = 0.0;
    private double sz22 = 0.0;
    private double sz23 = 0.0;
    private double sz31 = 0.0;
    private double sz32 = 0.0;
    private double sz33 = 0.0;
    private double nm = 0.0;
    private final TimeZone tz = GMT_TZ;
    private double z1 = 0.0;
    private double z2 = 0.0;
    private double z3 = 0.0;
    private double z11 = 0.0;
    private double z12 = 0.0;
    private double z13 = 0.0;
    private double z21 = 0.0;
    private double z22 = 0.0;
    private double z23 = 0.0;
    private double z31 = 0.0;
    private double z32 = 0.0;
    private double z33 = 0.0;
    static final double x2o3 = 0.6666666666666666;
    private static final double fasx2 = 0.13130908;
    private static final double fasx4 = 2.8843198;
    private static final double fasx6 = 0.37448087;
    private static final double g22 = 5.7686396;
    private static final double g32 = 0.95240898;
    private static final double g44 = 1.8014998;
    private static final double g52 = 1.050833;
    private static final double g54 = 4.4108898;
    private static final double rptim = 0.0043752690880113;
    private static final double stepp = 720.0;
    private static final double stepn = -720.0;
    private static final double step2 = 259200.0;

    public static void mainX(String[] stringArray) {
        long l = System.currentTimeMillis();
        try {
            Sgp4Unit sgp4Unit = new Sgp4Unit(new SatElset("1 00005U 58002B   00179.78495062  .00000023  00000-0  28098-4 0  4753", "2 00005  34.2682 348.7242 1859667 331.7664  19.3264 10.82419157413667"));
            Vector<Sgp4Data> vector = sgp4Unit.runSgp4(0.0, 4320.0, 360.0);
            for (Sgp4Data sgp4Data : vector) {
                Vector3d vector3d = sgp4Data.getPosn();
                Vector3d vector3d2 = sgp4Data.getVel();
                System.out.println("x " + vector3d.x * 6378.137 + " y " + vector3d.y * 6378.137 + " z " + vector3d.z * 6378.137 + " vx " + vector3d2.x * 7.905372989414837 + " vy " + vector3d2.y * 7.905372989414837 + " vz " + vector3d2.z * 7.905372989414837);
            }
            System.out.println("time to process (millisec): " + (System.currentTimeMillis() - l));
        }
        catch (ObjectDecayed objectDecayed) {
            System.out.println("decayed " + objectDecayed);
        }
        catch (SatElsetException satElsetException) {
            System.out.println("elset exception " + satElsetException);
        }
    }

    public Sgp4Unit() {
    }

    public Sgp4Unit(SatElset satElset) throws SatElsetException, ObjectDecayed {
        this.twoline2rv(satElset);
    }

    private void dpper(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, double d18, double d19, double d20, double d21, double d22, double d23, double d24, double d25, double d26, double d27, boolean bl) {
        double d28 = d27 + 1.19459E-5 * d15;
        if (bl) {
            d28 = d27;
        }
        double d29 = d28 + 0.0335 * Math.sin(d28);
        double d30 = Math.sin(d29);
        double d31 = 0.5 * d30 * d30 - 0.25;
        double d32 = -0.5 * d30 * Math.cos(d29);
        double d33 = d3 * d31 + d4 * d32;
        double d34 = d10 * d31 + d11 * d32;
        double d35 = d12 * d31 + d13 * d32 + d14 * d30;
        double d36 = d5 * d31 + d6 * d32 + d7 * d30;
        double d37 = d8 * d31 + d9 * d32;
        d28 = d26 + 1.5835218E-4 * d15;
        if (bl) {
            d28 = d26;
        }
        d29 = d28 + 0.1098 * Math.sin(d28);
        d30 = Math.sin(d29);
        d31 = 0.5 * d30 * d30 - 0.25;
        d32 = -0.5 * d30 * Math.cos(d29);
        double d38 = d2 * d31 + d * d32;
        double d39 = d21 * d31 + d22 * d32;
        double d40 = d23 * d31 + d24 * d32 + d25 * d30;
        double d41 = d16 * d31 + d17 * d32 + d18 * d30;
        double d42 = d19 * d31 + d20 * d32;
        double d43 = d33 + d38;
        double d44 = d34 + d39;
        double d45 = d35 + d40;
        double d46 = d36 + d41;
        double d47 = d37 + d42;
        if (!bl) {
            this.satrec.xincp += d44;
            this.satrec.ep += d43;
            double d48 = Math.sin(this.satrec.xincp);
            double d49 = Math.cos(this.satrec.xincp);
            if (this.satrec.xincp >= 0.2) {
                this.satrec.argpp += (d46 -= d49 * (d47 /= d48));
                this.satrec.omegap += d47;
                this.satrec.mp += d45;
            } else {
                double d50 = Math.sin(this.satrec.omegap);
                double d51 = Math.cos(this.satrec.omegap);
                double d52 = d48 * d50;
                double d53 = d48 * d51;
                double d54 = d47 * d51 + d44 * d49 * d50;
                double d55 = -d47 * d50 + d44 * d49 * d51;
                this.satrec.omegap %= Math.PI * 2;
                double d56 = d45 + d46 - d44 * this.satrec.omegap * d48;
                double d57 = this.satrec.mp + this.satrec.argpp + d49 * this.satrec.omegap + d56;
                double d58 = this.satrec.omegap;
                this.satrec.omegap = Math.atan2(d52 += d54, d53 += d55);
                if (Math.abs(d58 - this.satrec.omegap) > Math.PI) {
                    this.satrec.omegap = this.satrec.omegap < d58 ? (this.satrec.omegap += Math.PI * 2) : (this.satrec.omegap -= Math.PI * 2);
                }
                this.satrec.mp += d45;
                this.satrec.argpp = d57 - this.satrec.mp - d49 * this.satrec.omegap;
            }
        }
    }

    private void dscom(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.nm = d7;
        this.em = d2;
        this.snodm = Math.sin(d6);
        this.cnodm = Math.cos(d6);
        this.sinomm = Math.sin(d3);
        this.cosomm = Math.cos(d3);
        this.sinim = Math.sin(d5);
        this.cosim = Math.cos(d5);
        this.emsq = this.em * this.em;
        double d8 = 1.0 - this.emsq;
        this.rtemsq = Math.sqrt(d8);
        this.day = d + 18261.5 + d4 / 1440.0;
        double d9 = (4.523602 - 9.2422029E-4 * this.day) % (Math.PI * 2);
        double d10 = Math.sin(d9);
        double d11 = Math.cos(d9);
        double d12 = 0.91375164 - 0.03568096 * d11;
        double d13 = Math.sqrt(1.0 - d12 * d12);
        double d14 = 0.089683511 * d10 / d13;
        double d15 = Math.sqrt(1.0 - d14 * d14);
        this.gam = 5.8351514 + 0.001944368 * this.day;
        double d16 = 0.39785416 * d10 / d13;
        double d17 = d15 * d11 + 0.91744867 * d14 * d10;
        d16 = Math.atan2(d16, d17);
        d16 = this.gam + d16 - d9;
        double d18 = Math.cos(d16);
        double d19 = Math.sin(d16);
        double d20 = 0.1945905;
        double d21 = -0.98088458;
        double d22 = 0.91744867;
        double d23 = 0.39785416;
        double d24 = this.cnodm;
        double d25 = this.snodm;
        double d26 = 2.9864797E-6;
        double d27 = 1.0 / this.nm;
        for (int i = 1; i <= 2; ++i) {
            double d28 = d20 * d24 + d21 * d22 * d25;
            double d29 = -d21 * d24 + d20 * d22 * d25;
            double d30 = -d20 * d25 + d21 * d22 * d24;
            double d31 = d21 * d23;
            double d32 = d21 * d25 + d20 * d22 * d24;
            double d33 = d20 * d23;
            double d34 = this.cosim * d30 + this.sinim * d31;
            double d35 = this.cosim * d32 + this.sinim * d33;
            double d36 = -this.sinim * d30 + this.cosim * d31;
            double d37 = -this.sinim * d32 + this.cosim * d33;
            double d38 = d28 * this.cosomm + d34 * this.sinomm;
            double d39 = d29 * this.cosomm + d35 * this.sinomm;
            double d40 = -d28 * this.sinomm + d34 * this.cosomm;
            double d41 = -d29 * this.sinomm + d35 * this.cosomm;
            double d42 = d36 * this.sinomm;
            double d43 = d37 * this.sinomm;
            double d44 = d36 * this.cosomm;
            double d45 = d37 * this.cosomm;
            this.z31 = 12.0 * d38 * d38 - 3.0 * d40 * d40;
            this.z32 = 24.0 * d38 * d39 - 6.0 * d40 * d41;
            this.z33 = 12.0 * d39 * d39 - 3.0 * d41 * d41;
            this.z1 = 3.0 * (d28 * d28 + d34 * d34) + this.z31 * this.emsq;
            this.z2 = 6.0 * (d28 * d29 + d34 * d35) + this.z32 * this.emsq;
            this.z3 = 3.0 * (d29 * d29 + d35 * d35) + this.z33 * this.emsq;
            this.z11 = -6.0 * d28 * d36 + this.emsq * (-24.0 * d38 * d44 - 6.0 * d40 * d42);
            this.z12 = -6.0 * (d28 * d37 + d29 * d36) + this.emsq * (-24.0 * (d39 * d44 + d38 * d45) - 6.0 * (d40 * d43 + d41 * d42));
            this.z13 = -6.0 * d29 * d37 + this.emsq * (-24.0 * d39 * d45 - 6.0 * d41 * d43);
            this.z21 = 6.0 * d34 * d36 + this.emsq * (24.0 * d38 * d42 - 6.0 * d40 * d44);
            this.z22 = 6.0 * (d35 * d36 + d34 * d37) + this.emsq * (24.0 * (d39 * d42 + d38 * d43) - 6.0 * (d41 * d44 + d40 * d45));
            this.z23 = 6.0 * d35 * d37 + this.emsq * (24.0 * d39 * d43 - 6.0 * d41 * d45);
            this.z1 = this.z1 + this.z1 + d8 * this.z31;
            this.z2 = this.z2 + this.z2 + d8 * this.z32;
            this.z3 = this.z3 + this.z3 + d8 * this.z33;
            this.s3 = d26 * d27;
            this.s2 = -0.5 * this.s3 / this.rtemsq;
            this.s4 = this.s3 * this.rtemsq;
            this.s1 = -15.0 * this.em * this.s4;
            this.s5 = d38 * d40 + d39 * d41;
            this.s6 = d39 * d40 + d38 * d41;
            this.s7 = d39 * d41 - d38 * d40;
            if (i != 1) continue;
            this.ss1 = this.s1;
            this.ss2 = this.s2;
            this.ss3 = this.s3;
            this.ss4 = this.s4;
            this.ss5 = this.s5;
            this.ss6 = this.s6;
            this.ss7 = this.s7;
            this.sz1 = this.z1;
            this.sz2 = this.z2;
            this.sz3 = this.z3;
            this.sz11 = this.z11;
            this.sz12 = this.z12;
            this.sz13 = this.z13;
            this.sz21 = this.z21;
            this.sz22 = this.z22;
            this.sz23 = this.z23;
            this.sz31 = this.z31;
            this.sz32 = this.z32;
            this.sz33 = this.z33;
            d20 = d18;
            d21 = d19;
            d22 = d12;
            d23 = d13;
            d24 = d15 * this.cnodm + d14 * this.snodm;
            d25 = this.snodm * d15 - this.cnodm * d14;
            d26 = 4.7968065E-7;
        }
        this.satrec.dsvalues.zmol = (4.7199672 + 0.2299715 * this.day - this.gam) % (Math.PI * 2);
        this.satrec.dsvalues.zmos = (6.2565837 + 0.017201977 * this.day) % (Math.PI * 2);
        this.satrec.dsvalues.se2 = 2.0 * this.ss1 * this.ss6;
        this.satrec.dsvalues.se3 = 2.0 * this.ss1 * this.ss7;
        this.satrec.dsvalues.si2 = 2.0 * this.ss2 * this.sz12;
        this.satrec.dsvalues.si3 = 2.0 * this.ss2 * (this.sz13 - this.sz11);
        this.satrec.dsvalues.sl2 = -2.0 * this.ss3 * this.sz2;
        this.satrec.dsvalues.sl3 = -2.0 * this.ss3 * (this.sz3 - this.sz1);
        this.satrec.dsvalues.sl4 = -2.0 * this.ss3 * (-21.0 - 9.0 * this.emsq) * 0.01675;
        this.satrec.dsvalues.sgh2 = 2.0 * this.ss4 * this.sz32;
        this.satrec.dsvalues.sgh3 = 2.0 * this.ss4 * (this.sz33 - this.sz31);
        this.satrec.dsvalues.sgh4 = -18.0 * this.ss4 * 0.01675;
        this.satrec.dsvalues.sh2 = -2.0 * this.ss2 * this.sz22;
        this.satrec.dsvalues.sh3 = -2.0 * this.ss2 * (this.sz23 - this.sz21);
        this.satrec.dsvalues.ee2 = 2.0 * this.s1 * this.s6;
        this.satrec.dsvalues.e3 = 2.0 * this.s1 * this.s7;
        this.satrec.dsvalues.xi2 = 2.0 * this.s2 * this.z12;
        this.satrec.dsvalues.xi3 = 2.0 * this.s2 * (this.z13 - this.z11);
        this.satrec.dsvalues.xl2 = -2.0 * this.s3 * this.z2;
        this.satrec.dsvalues.xl3 = -2.0 * this.s3 * (this.z3 - this.z1);
        this.satrec.dsvalues.xl4 = -2.0 * this.s3 * (-21.0 - 9.0 * this.emsq) * 0.0549;
        this.satrec.dsvalues.xgh2 = 2.0 * this.s4 * this.z32;
        this.satrec.dsvalues.xgh3 = 2.0 * this.s4 * (this.z33 - this.z31);
        this.satrec.dsvalues.xgh4 = -18.0 * this.s4 * 0.0549;
        this.satrec.dsvalues.xh2 = -2.0 * this.s2 * this.z22;
        this.satrec.dsvalues.xh3 = -2.0 * this.s2 * (this.z23 - this.z21);
    }

    private void dsinit(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, double d18, double d19, double d20, double d21, double d22, double d23, double d24, double d25, double d26, double d27, double d28) {
        double d29 = 0.0;
        this.satrec.dsvalues.irez = 0;
        if (this.nm < 0.0052359877 && this.nm > 0.0034906585) {
            this.satrec.dsvalues.irez = 1;
        }
        if (this.nm >= 0.00826 && this.nm <= 0.00924 && this.em >= 0.5) {
            this.satrec.dsvalues.irez = 2;
        }
        double d30 = this.ss1 * 1.19459E-5 * this.ss5;
        double d31 = this.ss2 * 1.19459E-5 * (this.sz11 + this.sz13);
        double d32 = -1.19459E-5 * this.ss3 * (this.sz1 + this.sz3 - 14.0 - 6.0 * d2);
        double d33 = this.ss4 * 1.19459E-5 * (this.sz31 + this.sz33 - 6.0);
        double d34 = -1.19459E-5 * this.ss2 * (this.sz21 + this.sz23);
        if (this.inclm < 0.052359877 || this.inclm > 3.0892327765897933) {
            d34 = 0.0;
        }
        if (d9 != 0.0) {
            d34 /= d9;
        }
        double d35 = d33 - d * d34;
        this.satrec.dsvalues.dedt = d30 + d4 * 1.5835218E-4 * d8;
        this.satrec.dsvalues.didt = d31 + d5 * 1.5835218E-4 * (d21 + d22);
        this.satrec.dsvalues.dmdt = d32 - 1.5835218E-4 * d6 * (d19 + d20 - 14.0 - 6.0 * d2);
        double d36 = d7 * 1.5835218E-4 * (d25 + d26 - 6.0);
        double d37 = -1.5835218E-4 * d5 * (d23 + d24);
        if (this.inclm < 0.052359877 || this.inclm > 3.0892327765897933) {
            d37 = 0.0;
        }
        this.satrec.dsvalues.domdt = d35 + d36;
        this.satrec.dsvalues.dnodt = d34;
        if (d9 != 0.0) {
            this.satrec.dsvalues.domdt -= d / d9 * d37;
            this.satrec.dsvalues.dnodt += d37 / d9;
        }
        this.dndt = 0.0;
        double d38 = (d12 + d11 * 0.0043752690880113) % (Math.PI * 2);
        this.em += this.satrec.dsvalues.dedt * d10;
        this.inclm += this.satrec.dsvalues.didt * d10;
        this.argpm += this.satrec.dsvalues.domdt * d10;
        this.omegam += this.satrec.dsvalues.dnodt * d10;
        this.mm += this.satrec.dsvalues.dmdt * d10;
        if (this.satrec.dsvalues.irez != 0) {
            double d39;
            double d40;
            double d41;
            double d42;
            double d43;
            double d44;
            d29 = Math.pow(this.nm / GravConstants.xke, 0.6666666666666666);
            if (this.satrec.dsvalues.irez == 2) {
                double d45;
                double d46;
                double d47;
                double d48 = d * d;
                double d49 = this.em;
                this.em = d27;
                double d50 = d2;
                d2 = d28;
                double d51 = this.em * d2;
                double d52 = -0.306 - (this.em - 0.64) * 0.44;
                if (this.em <= 0.65) {
                    d44 = 3.616 - 13.247 * this.em + 16.29 * d2;
                    d43 = -19.302 + 117.39 * this.em - 228.419 * d2 + 156.591 * d51;
                    d42 = -18.9068 + 109.7927 * this.em - 214.6334 * d2 + 146.5816 * d51;
                    d41 = -41.122 + 242.694 * this.em - 471.094 * d2 + 313.953 * d51;
                    d40 = -146.407 + 841.88 * this.em - 1629.014 * d2 + 1083.435 * d51;
                    d39 = -532.114 + 3017.977 * this.em - 5740.032 * d2 + 3708.276 * d51;
                } else {
                    d44 = -72.099 + 331.819 * this.em - 508.738 * d2 + 266.724 * d51;
                    d43 = -346.844 + 1582.851 * this.em - 2415.925 * d2 + 1246.113 * d51;
                    d42 = -342.585 + 1554.908 * this.em - 2366.899 * d2 + 1215.972 * d51;
                    d41 = -1052.797 + 4758.686 * this.em - 7193.992 * d2 + 3651.957 * d51;
                    d40 = -3581.69 + 16178.11 * this.em - 24462.77 * d2 + 12422.52 * d51;
                    d39 = this.em > 0.715 ? -5149.66 + 29936.92 * this.em - 54087.36 * d2 + 31324.56 * d51 : 1464.74 - 4664.75 * this.em + 3763.64 * d2;
                }
                if (this.em < 0.7) {
                    d47 = -919.2277 + 4988.61 * this.em - 9064.77 * d2 + 5542.21 * d51;
                    d46 = -822.71072 + 4568.6173 * this.em - 8491.4146 * d2 + 5337.524 * d51;
                    d45 = -853.666 + 4690.25 * this.em - 8624.77 * d2 + 5341.4 * d51;
                } else {
                    d47 = -37995.78 + 161616.52 * this.em - 229838.2 * d2 + 109377.94 * d51;
                    d46 = -51752.104 + 218913.95 * this.em - 309468.16 * d2 + 146349.42 * d51;
                    d45 = -40023.88 + 170470.89 * this.em - 242699.48 * d2 + 115605.82 * d51;
                }
                double d53 = d9 * d9;
                double d54 = 0.75 * (1.0 + 2.0 * d + d48);
                double d55 = 1.5 * d53;
                double d56 = 1.875 * d9 * (1.0 - 2.0 * d - 3.0 * d48);
                double d57 = -1.875 * d9 * (1.0 + 2.0 * d - 3.0 * d48);
                double d58 = 35.0 * d53 * d54;
                double d59 = 39.375 * d53 * d53;
                double d60 = 9.84375 * d9 * (d53 * (1.0 - 2.0 * d - 5.0 * d48) + 0.33333333 * (-2.0 + 4.0 * d + 6.0 * d48));
                double d61 = d9 * (4.92187512 * d53 * (-2.0 - 4.0 * d + 10.0 * d48) + 6.56250012 * (1.0 + 2.0 * d - 3.0 * d48));
                double d62 = 29.53125 * d9 * (2.0 - 8.0 * d + d48 * (-12.0 + 8.0 * d + 10.0 * d48));
                double d63 = 29.53125 * d9 * (-2.0 - 8.0 * d + d48 * (12.0 + 8.0 * d - 10.0 * d48));
                double d64 = this.nm * this.nm;
                double d65 = d29 * d29;
                double d66 = 3.0 * d64 * d65;
                double d67 = d66 * 1.7891679E-6;
                this.satrec.dsvalues.d2201 = d67 * d54 * d52;
                this.satrec.dsvalues.d2211 = d67 * d55 * d44;
                d67 = (d66 *= d29) * 3.7393792E-7;
                this.satrec.dsvalues.d3210 = d67 * d56 * d43;
                this.satrec.dsvalues.d3222 = d67 * d57 * d42;
                d67 = 2.0 * (d66 *= d29) * 7.3636953E-9;
                this.satrec.dsvalues.d4410 = d67 * d58 * d41;
                this.satrec.dsvalues.d4422 = d67 * d59 * d40;
                d67 = (d66 *= d29) * 1.1428639E-7;
                this.satrec.dsvalues.d5220 = d67 * d60 * d39;
                this.satrec.dsvalues.d5232 = d67 * d61 * d45;
                d67 = 2.0 * d66 * 2.1765803E-9;
                this.satrec.dsvalues.d5421 = d67 * d62 * d46;
                this.satrec.dsvalues.d5433 = d67 * d63 * d47;
                this.satrec.dsvalues.xlamo = (d13 + d16 + d16 - d38 - d38) % (Math.PI * 2);
                this.satrec.dsvalues.xfact = d14 + this.satrec.dsvalues.dmdt + 2.0 * (d17 + this.satrec.dsvalues.dnodt - 0.0043752690880113) - d15;
                this.em = d49;
                d2 = d50;
            }
            if (this.satrec.dsvalues.irez == 1) {
                d44 = 1.0 + d2 * (-2.5 + 0.8125 * d2);
                d43 = 1.0 + 2.0 * d2;
                d42 = 1.0 + d2 * (-6.0 + 6.60937 * d2);
                d41 = 0.75 * (1.0 + d) * (1.0 + d);
                d40 = 0.9375 * d9 * d9 * (1.0 + 3.0 * d) - 0.75 * (1.0 + d);
                d39 = 1.0 + d;
                d39 = 1.875 * d39 * d39 * d39;
                this.satrec.dsvalues.del1 = 3.0 * this.nm * this.nm * d29 * d29;
                this.satrec.dsvalues.del2 = 2.0 * this.satrec.dsvalues.del1 * d41 * d44 * 1.7891679E-6;
                this.satrec.dsvalues.del3 = 3.0 * this.satrec.dsvalues.del1 * d39 * d42 * 2.2123015E-7 * d29;
                this.satrec.dsvalues.del1 = this.satrec.dsvalues.del1 * d40 * d43 * 2.1460748E-6 * d29;
                this.satrec.dsvalues.xlamo = (d13 + d16 + d3 - d38) % (Math.PI * 2);
                this.satrec.dsvalues.xfact = d14 + d18 - 0.0043752690880113 + this.satrec.dsvalues.dmdt + this.satrec.dsvalues.domdt + this.satrec.dsvalues.dnodt - d15;
            }
            this.satrec.dsvalues.xli = this.satrec.dsvalues.xlamo;
            this.satrec.dsvalues.xni = d15;
            this.satrec.dsvalues.atime = 0.0;
            this.nm = d15 + this.dndt;
        }
    }

    private void dspace(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, double d18, double d19, double d20, double d21, double d22, double d23, double d24, double d25, double d26) {
        double d27 = 0.0;
        double d28 = 0.0;
        double d29 = 0.0;
        double d30 = 0.0;
        this.dndt = 0.0;
        double d31 = (d23 + d22 * 0.0043752690880113) % (Math.PI * 2);
        this.em += d11 * d21;
        this.inclm += d15 * d21;
        this.argpm += d18 * d21;
        this.omegam += d17 * d21;
        this.mm += d16 * d21;
        d27 = 0.0;
        this.satrec.dsvalues.atime = 0.0;
        if (n != 0) {
            double d32;
            if (this.satrec.dsvalues.atime == 0.0 || d21 >= 0.0 && this.satrec.dsvalues.atime < 0.0 || d21 < 0.0 && this.satrec.dsvalues.atime >= 0.0) {
                d32 = d21 >= 0.0 ? 720.0 : -720.0;
                this.satrec.dsvalues.atime = 0.0;
                this.satrec.dsvalues.xni = d26;
                this.satrec.dsvalues.xli = d25;
            }
            int n2 = 381;
            int n3 = 0;
            while (n2 == 381) {
                if (Math.abs(d21) < Math.abs(this.satrec.dsvalues.atime) || n3 == 351) {
                    d32 = d21 >= 0.0 ? -720.0 : 720.0;
                    n3 = 351;
                    n2 = 381;
                } else {
                    d32 = d21 > 0.0 ? 720.0 : -720.0;
                    if (Math.abs(d21 - this.satrec.dsvalues.atime) >= 720.0) {
                        n3 = 0;
                        n2 = 381;
                    } else {
                        d27 = d21 - this.satrec.dsvalues.atime;
                        n2 = 0;
                    }
                }
                if (n != 2) {
                    d30 = d12 * Math.sin(this.satrec.dsvalues.xli - 0.13130908) + d13 * Math.sin(2.0 * (this.satrec.dsvalues.xli - 2.8843198)) + d14 * Math.sin(3.0 * (this.satrec.dsvalues.xli - 0.37448087));
                    d28 = this.satrec.dsvalues.xni + d24;
                    d29 = d12 * Math.cos(this.satrec.dsvalues.xli - 0.13130908) + 2.0 * d13 * Math.cos(2.0 * (this.satrec.dsvalues.xli - 2.8843198)) + 3.0 * d14 * Math.cos(3.0 * (this.satrec.dsvalues.xli - 0.37448087));
                    d29 *= d28;
                } else {
                    double d33 = d19 + d20 * this.satrec.dsvalues.atime;
                    double d34 = d33 + d33;
                    double d35 = this.satrec.dsvalues.xli + this.satrec.dsvalues.xli;
                    d30 = d * Math.sin(d34 + this.satrec.dsvalues.xli - 5.7686396) + d2 * Math.sin(this.satrec.dsvalues.xli - 5.7686396) + d3 * Math.sin(d33 + this.satrec.dsvalues.xli - 0.95240898) + d4 * Math.sin(-d33 + this.satrec.dsvalues.xli - 0.95240898) + d5 * Math.sin(d34 + d35 - 1.8014998) + d6 * Math.sin(d35 - 1.8014998) + d7 * Math.sin(d33 + this.satrec.dsvalues.xli - 1.050833) + d8 * Math.sin(-d33 + this.satrec.dsvalues.xli - 1.050833) + d9 * Math.sin(d33 + d35 - 4.4108898) + d10 * Math.sin(-d33 + d35 - 4.4108898);
                    d28 = this.satrec.dsvalues.xni + d24;
                    d29 = d * Math.cos(d34 + this.satrec.dsvalues.xli - 5.7686396) + d2 * Math.cos(this.satrec.dsvalues.xli - 5.7686396) + d3 * Math.cos(d33 + this.satrec.dsvalues.xli - 0.95240898) + d4 * Math.cos(-d33 + this.satrec.dsvalues.xli - 0.95240898) + d7 * Math.cos(d33 + this.satrec.dsvalues.xli - 1.050833) + d8 * Math.cos(-d33 + this.satrec.dsvalues.xli - 1.050833) + 2.0 * (d5 * Math.cos(d34 + d35 - 1.8014998) + d6 * Math.cos(d35 - 1.8014998) + d9 * Math.cos(d33 + d35 - 4.4108898) + d10 * Math.cos(-d33 + d35 - 4.4108898));
                    d29 *= d28;
                }
                if (n2 != 381) continue;
                this.satrec.dsvalues.xli = this.satrec.dsvalues.xli + d28 * d32 + d30 * 259200.0;
                this.satrec.dsvalues.xni = this.satrec.dsvalues.xni + d30 * d32 + d29 * 259200.0;
                this.satrec.dsvalues.atime += d32;
            }
            this.nm = this.satrec.dsvalues.xni + d30 * d27 + d29 * d27 * d27 * 0.5;
            double d36 = this.satrec.dsvalues.xli + d28 * d27 + d30 * d27 * d27 * 0.5;
            this.mm = n != 1 ? d36 - 2.0 * this.omegam + 2.0 * d31 : d36 - this.omegam - this.argpm + d31;
            this.dndt = this.nm - d26;
            this.nm = d26 + this.dndt;
        }
    }

    private double gstime(double d) {
        double d2 = (d - 2451545.0) / 36525.0;
        double d3 = -6.2E-6 * d2 * d2 * d2 + 0.093104 * d2 * d2 + 3.164400184812866E9 * d2 + 67310.54841;
        if ((d3 = d3 * (Math.PI / 180) / 240.0 % (Math.PI * 2)) < 0.0) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    private void initl(int n, double d, double d2, double d3) throws ObjectDecayed {
        this.eccsq = d * d;
        this.omeosq = 1.0 - this.eccsq;
        this.rteosq = Math.sqrt(this.omeosq);
        this.cosio = Math.cos(d3);
        this.cosio2 = this.cosio * this.cosio;
        double d4 = Math.pow(GravConstants.xke / this.satrec.no, 0.6666666666666666);
        double d5 = 8.119724917875E-4 * (3.0 * this.cosio2 - 1.0) / (this.rteosq * this.omeosq);
        double d6 = d5 / (d4 * d4);
        double d7 = d4 * (1.0 - d6 * d6 - d6 * (0.3333333333333333 + 134.0 * d6 * d6 / 81.0));
        this.satrec.no /= 1.0 + d5 / (d7 * d7);
        this.ao = Math.pow(GravConstants.xke / this.satrec.no, 0.6666666666666666);
        this.sinio = Math.sin(d3);
        double d8 = this.ao * this.omeosq;
        this.posq = d8 * d8;
        this.con42 = 1.0 - 5.0 * this.cosio2;
        this.satrec.nevalues.con41 = -this.con42 - this.cosio2 - this.cosio2;
        this.rp = this.ao * (1.0 - d);
        this.satrec.nevalues.method = 0;
        if (this.rp < 1.0) {
            throw new ObjectDecayed("Sgp4Unit.initl Fatal SGP4 error [satn: " + n + " epoch elts sub-orbital]");
        }
        this.satrec.dsvalues.gsto = this.gstime(d2 + 2433281.5);
    }

    private double julianday(int n, int n2, int n3, int n4, int n5, double d) {
        double d2 = 367.0 * (double)n - (double)((int)((double)(7 * (n + (n2 + 9) / 12)) * 0.25)) + (double)(275 * n2 / 9) + (double)n3 + 1721013.5 + ((d / 60.0 + (double)n5) / 60.0 + (double)n4) / 24.0;
        return d2;
    }

    public Sgp4Data runSgp4(int n, double d) throws ObjectDecayed {
        if (n < 1900) {
            n = n < 50 ? (n += 2000) : (n += 1900);
        }
        double d2 = (double)((n - 1950) * 365 + (n - 1949) / 4) + d;
        this.satrec.nevalues.t = (d2 - this.satrec.eptime) * 1440.0;
        return this.sgp4();
    }

    public Vector<Sgp4Data> runSgp4(double d, double d2, double d3) throws SatElsetException, ObjectDecayed {
        Vector<Sgp4Data> vector = new Vector<Sgp4Data>();
        this.satrec.nevalues.t = d;
        double d4 = d2 + d3;
        boolean bl = false;
        while (this.satrec.nevalues.t < d4 && this.satrec.error == 0 && !bl) {
            if (this.satrec.nevalues.t > d4) {
                this.satrec.nevalues.t = d4;
                bl = true;
            }
            vector.addElement(this.sgp4());
            this.satrec.nevalues.t += d3;
        }
        return vector;
    }

    public Vector<Sgp4Data> runSgp4(int n, double d, int n2, double d2) throws SatElsetException, ObjectDecayed {
        int n3;
        int n4;
        if (n < 1900) {
            n = n < 50 ? (n += 2000) : (n += 1900);
        }
        double d3 = ((double)((n - 1950) * 365 + (n - 1949) / 4) + d - this.satrec.eptime) * 1440.0;
        Vector<Sgp4Data> vector = new Vector<Sgp4Data>(n2);
        for (n4 = n3 = (n2 - 1) / 2; n4 >= 0; --n4) {
            this.satrec.nevalues.t = d3 - (double)n4 * d2;
            vector.addElement(this.sgp4());
        }
        for (n4 = 1; n4 <= n3; ++n4) {
            this.satrec.nevalues.t = d3 + (double)n4 * d2;
            vector.addElement(this.sgp4());
        }
        return vector;
    }

    public Vector<Sgp4Data> runSgp4(int n, double d, int n2, double d2, double d3) throws SatElsetException, ObjectDecayed {
        if (n < 1900) {
            n = n < 50 ? (n += 2000) : (n += 1900);
        }
        if (n2 < 1900) {
            n2 = n2 < 50 ? (n2 += 2000) : (n2 += 1900);
        }
        double d4 = (double)((n - 1950) * 365 + (n - 1949) / 4) + d;
        double d5 = (double)((n2 - 1950) * 365 + (n2 - 1949) / 4) + d2;
        Vector<Sgp4Data> vector = new Vector<Sgp4Data>();
        this.satrec.nevalues.t = (d4 - this.satrec.eptime) * 1440.0;
        double d6 = (d5 - this.satrec.eptime) * 1440.0 + d3;
        boolean bl = false;
        while (this.satrec.nevalues.t < d6 && this.satrec.error == 0 && !bl) {
            if (this.satrec.nevalues.t > d6) {
                this.satrec.nevalues.t = d6;
                bl = true;
            }
            vector.addElement(this.sgp4());
            this.satrec.nevalues.t += d3;
        }
        return vector;
    }

    public Sgp4Data sgp4() throws ObjectDecayed {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        this.satrec.error = 0;
        double d8 = this.satrec.mo + this.satrec.nevalues.mdot * this.satrec.nevalues.t;
        double d9 = this.satrec.argpo + this.satrec.nevalues.argpdot * this.satrec.nevalues.t;
        double d10 = this.satrec.omegao + this.satrec.nevalues.omegadot * this.satrec.nevalues.t;
        this.argpm = d9;
        this.mm = d8;
        double d11 = this.satrec.nevalues.t * this.satrec.nevalues.t;
        this.omegam = d10 + this.satrec.nevalues.omegacf * d11;
        double d12 = 1.0 - this.satrec.nevalues.cc1 * this.satrec.nevalues.t;
        double d13 = this.satrec.bstar * this.satrec.nevalues.cc4 * this.satrec.nevalues.t;
        double d14 = this.satrec.nevalues.t2cof * d11;
        if (this.satrec.nevalues.isimp != 1) {
            d7 = this.satrec.nevalues.omgcof * this.satrec.nevalues.t;
            d6 = this.satrec.nevalues.xmcof * (Math.pow(1.0 + this.satrec.nevalues.eta * Math.cos(d8), 3.0) - this.satrec.nevalues.delmo);
            d5 = d7 + d6;
            this.mm = d8 + d5;
            this.argpm = d9 - d5;
            d4 = d11 * this.satrec.nevalues.t;
            d3 = d4 * this.satrec.nevalues.t;
            d12 = d12 - this.satrec.nevalues.d2 * d11 - this.satrec.nevalues.d3 * d4 - this.satrec.nevalues.d4 * d3;
            d13 += this.satrec.bstar * this.satrec.nevalues.cc5 * (Math.sin(this.mm) - this.satrec.nevalues.sinmao);
            d14 = d14 + this.satrec.nevalues.t3cof * d4 + d3 * (this.satrec.nevalues.t4cof + this.satrec.nevalues.t * this.satrec.nevalues.t5cof);
        }
        this.nm = this.satrec.no;
        this.em = this.satrec.ecco;
        this.inclm = this.satrec.inclo;
        if (this.satrec.nevalues.method == 2) {
            d7 = this.satrec.nevalues.t;
            this.dspace(this.satrec.dsvalues.irez, this.satrec.dsvalues.d2201, this.satrec.dsvalues.d2211, this.satrec.dsvalues.d3210, this.satrec.dsvalues.d3222, this.satrec.dsvalues.d4410, this.satrec.dsvalues.d4422, this.satrec.dsvalues.d5220, this.satrec.dsvalues.d5232, this.satrec.dsvalues.d5421, this.satrec.dsvalues.d5433, this.satrec.dsvalues.dedt, this.satrec.dsvalues.del1, this.satrec.dsvalues.del2, this.satrec.dsvalues.del3, this.satrec.dsvalues.didt, this.satrec.dsvalues.dmdt, this.satrec.dsvalues.dnodt, this.satrec.dsvalues.domdt, this.satrec.argpo, this.satrec.nevalues.argpdot, this.satrec.nevalues.t, d7, this.satrec.dsvalues.gsto, this.satrec.dsvalues.xfact, this.satrec.dsvalues.xlamo, this.satrec.no);
        }
        if (this.nm <= 0.0) {
            this.satrec.error = 2;
            throw new ObjectDecayed("Sgp4Unit.sgp4 ERROR mean motion is less than zero [nm: " + this.nm + "]");
        }
        d7 = Math.pow(GravConstants.xke / this.nm, 0.6666666666666666) * d12 * d12;
        this.nm = GravConstants.xke / Math.pow(d7, 1.5);
        this.em -= d13;
        if (this.em >= 1.0 || this.em < -0.001) {
            this.satrec.error = 1;
            throw new ObjectDecayed("Sgp4Unit.sgp4 ERROR eccentricity out of bounds [em: " + this.em + "] [am: " + d7 + "] for sat: " + this.satrec.satnum);
        }
        if (this.em < 1.0E-6) {
            this.em = 1.0E-6;
        }
        this.mm += this.satrec.no * d14;
        d6 = (this.mm + this.argpm + this.omegam) % (Math.PI * 2);
        this.omegam %= Math.PI * 2;
        this.argpm %= Math.PI * 2;
        this.mm = (d6 - this.argpm - this.omegam) % (Math.PI * 2);
        d5 = Math.sin(this.inclm);
        d4 = Math.cos(this.inclm);
        this.satrec.ep = this.em;
        this.satrec.xincp = this.inclm;
        this.satrec.argpp = this.argpm;
        this.satrec.omegap = this.omegam;
        this.satrec.mp = this.mm;
        d3 = d5;
        double d15 = d4;
        if (this.satrec.nevalues.method == 2) {
            this.dpper(this.satrec.dsvalues.e3, this.satrec.dsvalues.ee2, this.satrec.dsvalues.se2, this.satrec.dsvalues.se3, this.satrec.dsvalues.sgh2, this.satrec.dsvalues.sgh3, this.satrec.dsvalues.sgh4, this.satrec.dsvalues.sh2, this.satrec.dsvalues.sh3, this.satrec.dsvalues.si2, this.satrec.dsvalues.si3, this.satrec.dsvalues.sl2, this.satrec.dsvalues.sl3, this.satrec.dsvalues.sl4, this.satrec.nevalues.t, this.satrec.dsvalues.xgh2, this.satrec.dsvalues.xgh3, this.satrec.dsvalues.xgh4, this.satrec.dsvalues.xh2, this.satrec.dsvalues.xh3, this.satrec.dsvalues.xi2, this.satrec.dsvalues.xi3, this.satrec.dsvalues.xl2, this.satrec.dsvalues.xl3, this.satrec.dsvalues.xl4, this.satrec.dsvalues.zmol, this.satrec.dsvalues.zmos, false);
            if (this.satrec.xincp < 0.0) {
                this.satrec.xincp = -this.satrec.xincp;
                this.satrec.omegap += Math.PI;
                this.satrec.argpp -= Math.PI;
            }
            if (this.satrec.ep < 0.0 || this.satrec.ep > 1.0) {
                this.satrec.error = 3;
                throw new ObjectDecayed("Sgp4Unit.sgp4 ERROR eccentricity out of bounds [ep: " + this.satrec.ep + "]");
            }
        }
        if (this.satrec.nevalues.method == 2) {
            d3 = Math.sin(this.satrec.xincp);
            d15 = Math.cos(this.satrec.xincp);
            this.satrec.nevalues.aycof = 0.0011694452793710002 * d3;
            d2 = Math.abs(d15 + 1.0) > 1.5E-12 ? 1.0 + d15 : 1.5E-12;
            this.satrec.nevalues.xlcof = 5.847226396855001E-4 * d3 * (3.0 + 5.0 * d15) / d2;
        }
        d2 = this.satrec.ep * Math.cos(this.satrec.argpp);
        double d16 = 1.0 / (d7 * (1.0 - this.satrec.ep * this.satrec.ep));
        double d17 = this.satrec.ep * Math.sin(this.satrec.argpp) + d16 * this.satrec.nevalues.aycof;
        double d18 = this.satrec.mp + this.satrec.argpp + this.satrec.omegap + d16 * this.satrec.nevalues.xlcof * d2;
        double d19 = d2 * d2 + d17 * d17;
        double d20 = d7 * (1.0 - d19);
        if (d20 < 0.0) {
            this.satrec.error = 4;
            throw new ObjectDecayed("Sgp4Unit.sgp4 ERROR [pl: " + d20 + "]");
        }
        double d21 = (d18 - this.satrec.omegap) % (Math.PI * 2);
        Vector2d vector2d = Sgp4Unit.solveKepler(d21, d2, d17);
        double d22 = vector2d.x;
        double d23 = vector2d.y;
        double d24 = d2 * d23 + d17 * d22;
        double d25 = d2 * d22 - d17 * d23;
        double d26 = d7 * (1.0 - d24);
        double d27 = Math.sqrt(d7) * d25 / d26;
        double d28 = Math.sqrt(d20) / d26;
        double d29 = Math.sqrt(1.0 - d19);
        double d30 = d25 / (1.0 + d29);
        double d31 = d7 / d26 * (d22 - d17 - d2 * d30);
        double d32 = d7 / d26 * (d23 - d2 + d17 * d30);
        double d33 = (d32 + d32) * d31;
        double d34 = 1.0 - 2.0 * d31 * d31;
        double d35 = 1.0 / d20;
        double d36 = 5.41314994525E-4 * d35;
        double d37 = d36 * d35;
        if (this.satrec.nevalues.method == 2) {
            d = d15 * d15;
            this.satrec.nevalues.con41 = 3.0 * d - 1.0;
            this.satrec.nevalues.x1mth2 = 1.0 - d;
            this.satrec.nevalues.x7thm1 = 7.0 * d - 1.0;
        }
        d = d26 * (1.0 - 1.5 * d37 * d29 * this.satrec.nevalues.con41) + 0.5 * d36 * this.satrec.nevalues.x1mth2 * d34;
        double d38 = Math.atan2(d31, d32) - 0.25 * d37 * this.satrec.nevalues.x7thm1 * d33;
        double d39 = this.satrec.omegap + 1.5 * d37 * d15 * d33;
        double d40 = this.satrec.xincp + 1.5 * d37 * d15 * d3 * d34;
        double d41 = d27 - this.nm * d36 * this.satrec.nevalues.x1mth2 * d33 / GravConstants.xke;
        double d42 = d28 + this.nm * d36 * (this.satrec.nevalues.x1mth2 * d34 + 1.5 * this.satrec.nevalues.con41) / GravConstants.xke;
        Sgp4Data sgp4Data = Sgp4Unit.mkOrientation(d38, d, d39, d40, d41, d42);
        if (d < 1.0) {
            this.satrec.error = 6;
        }
        if (this.satrec.error > 0 && this.satrec.error == 4) {
            throw new ObjectDecayed("Sgp4Unit.sgp4 Fatal SGP4 error [pl: " + d20 + "]");
        }
        return sgp4Data;
    }

    private static Sgp4Data mkOrientation(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.sin(d);
        double d8 = Math.cos(d);
        double d9 = Math.sin(d3);
        double d10 = Math.cos(d3);
        double d11 = Math.sin(d4);
        double d12 = Math.cos(d4);
        double d13 = -d9 * d12;
        double d14 = d10 * d12;
        double d15 = d13 * d7 + d10 * d8;
        double d16 = d14 * d7 + d9 * d8;
        double d17 = d11 * d7;
        Vector3d vector3d = new Vector3d(d2 * d15, d2 * d16, d2 * d17);
        double d18 = d13 * d8 - d10 * d7;
        double d19 = d14 * d8 - d9 * d7;
        double d20 = d11 * d8;
        Vector3d vector3d2 = new Vector3d(d5 * d15 + d6 * d18, d5 * d16 + d6 * d19, d5 * d17 + d6 * d20);
        return new Sgp4Data(vector3d, vector3d2);
    }

    private static Vector2d solveKepler(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = d;
        double d7 = 9999.9;
        for (int i = 1; Math.abs(d7) >= 1.0E-12 && i <= 10; ++i) {
            d4 = Math.sin(d6);
            d5 = Math.cos(d6);
            d7 = 1.0 - d5 * d2 - d4 * d3;
            if (Math.abs(d7 = (d - d3 * d5 + d2 * d4 - d6) / d7) >= 0.95) {
                d7 = d7 > 0.0 ? 0.95 : -0.95;
            }
            d6 += d7;
        }
        return new Vector2d(d4, d5);
    }

    private void sgp4init(int n, int n2, double d) throws ObjectDecayed {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        this.ss4 = 0.0;
        this.ss3 = 0.0;
        this.ss2 = 0.0;
        this.ss1 = 0.0;
        this.ss7 = 0.0;
        this.ss6 = 0.0;
        this.ss5 = 0.0;
        this.sz13 = 0.0;
        this.sz12 = 0.0;
        this.sz11 = 0.0;
        this.sz3 = 0.0;
        this.sz2 = 0.0;
        this.sz1 = 0.0;
        this.sz33 = 0.0;
        this.sz32 = 0.0;
        this.sz31 = 0.0;
        this.sz23 = 0.0;
        this.sz22 = 0.0;
        this.sz21 = 0.0;
        this.z13 = 0.0;
        this.z12 = 0.0;
        this.z11 = 0.0;
        this.z3 = 0.0;
        this.z2 = 0.0;
        this.z1 = 0.0;
        this.z33 = 0.0;
        this.z32 = 0.0;
        this.z31 = 0.0;
        this.z23 = 0.0;
        this.z22 = 0.0;
        this.z21 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 0.0;
        d23 = 1.0122292763545218;
        d22 = Math.pow(0.006584994960127072, 4.0);
        this.initl(n, this.satrec.ecco, d, this.satrec.inclo);
        if (this.omeosq >= 0.0 || this.satrec.no >= 0.0) {
            this.satrec.nevalues.isimp = 0;
            if (this.rp < 1.0344928307435228) {
                this.satrec.nevalues.isimp = 1;
            }
            d14 = d23;
            d13 = d22;
            d10 = (this.rp - 1.0) * 6378.137;
            if (d10 < 156.0) {
                d14 = d10 - 78.0;
                if (d10 < 98.0) {
                    d14 = 20.0;
                }
                d13 = Math.pow((120.0 - d14) / 6378.137, 4.0);
                d14 = d14 / 6378.137 + 1.0;
            }
            d11 = 1.0 / this.posq;
            d19 = 1.0 / (this.ao - d14);
            this.satrec.nevalues.eta = this.ao * this.satrec.ecco * d19;
            d9 = this.satrec.nevalues.eta * this.satrec.nevalues.eta;
            d8 = this.satrec.ecco * this.satrec.nevalues.eta;
            d12 = Math.abs(1.0 - d9);
            d5 = d13 * Math.pow(d19, 4.0);
            d6 = d5 / Math.pow(d12, 3.5);
            d3 = d6 * this.satrec.no * (this.ao * (1.0 + 1.5 * d9 + d8 * (4.0 + d9)) + 4.0598624589375E-4 * d19 / d12 * this.satrec.nevalues.con41 * (8.0 + 3.0 * d9 * (8.0 + d9)));
            this.satrec.nevalues.cc1 = this.satrec.bstar * d3;
            d4 = 0.0;
            if (this.satrec.ecco > 1.0E-4) {
                d4 = -2.0 * d5 * d19 * -0.0023388905587420003 * this.satrec.no * this.sinio / this.satrec.ecco;
            }
            this.satrec.nevalues.x1mth2 = 1.0 - this.cosio2;
            this.satrec.nevalues.cc4 = 2.0 * this.satrec.no * d6 * this.ao * this.omeosq * (this.satrec.nevalues.eta * (2.0 + 0.5 * d9) + this.satrec.ecco * (0.5 + 2.0 * d9) - 0.00108262998905 * d19 / (this.ao * d12) * (-3.0 * this.satrec.nevalues.con41 * (1.0 - 2.0 * d8 + d9 * (1.5 - 0.5 * d8)) + 0.75 * this.satrec.nevalues.x1mth2 * (2.0 * d9 - d8 * (1.0 + d9)) * Math.cos(2.0 * this.satrec.argpo)));
            this.satrec.nevalues.cc5 = 2.0 * d6 * this.ao * this.omeosq * (1.0 + 2.75 * (d9 + d8) + d8 * d9);
            d7 = this.cosio2 * this.cosio2;
            d16 = 0.001623944983575 * d11 * this.satrec.no;
            d17 = 0.5 * d16 * 0.00108262998905 * d11;
            d18 = 7.551504421875001E-7 * d11 * d11 * this.satrec.no;
            this.satrec.nevalues.mdot = this.satrec.no + 0.5 * d16 * this.rteosq * this.satrec.nevalues.con41 + 0.0625 * d17 * this.rteosq * (13.0 - 78.0 * this.cosio2 + 137.0 * d7);
            this.satrec.nevalues.argpdot = -0.5 * d16 * this.con42 + 0.0625 * d17 * (7.0 - 114.0 * this.cosio2 + 395.0 * d7) + d18 * (3.0 - 36.0 * this.cosio2 + 49.0 * d7);
            d21 = -d16 * this.cosio;
            this.satrec.nevalues.omegadot = d21 + (0.5 * d17 * (4.0 - 19.0 * this.cosio2) + 2.0 * d18 * (3.0 - 7.0 * this.cosio2)) * this.cosio;
            d20 = this.satrec.nevalues.argpdot + this.satrec.nevalues.omegadot;
            this.satrec.nevalues.omgcof = this.satrec.bstar * d4 * Math.cos(this.satrec.argpo);
            this.satrec.nevalues.xmcof = 0.0;
            if (this.satrec.ecco > 1.0E-4) {
                this.satrec.nevalues.xmcof = -0.6666666666666666 * d5 * this.satrec.bstar / d8;
            }
            this.satrec.nevalues.omegacf = 3.5 * this.omeosq * d21 * this.satrec.nevalues.cc1;
            this.satrec.nevalues.t2cof = 1.5 * this.satrec.nevalues.cc1;
            this.satrec.nevalues.xlcof = Math.abs(this.cosio + 1.0) > 1.5E-12 ? 5.847226396855001E-4 * this.sinio * (3.0 + 5.0 * this.cosio) / (1.0 + this.cosio) : 5.847226396855001E-4 * this.sinio * (3.0 + 5.0 * this.cosio) / 1.5E-12;
            this.satrec.nevalues.aycof = 0.0011694452793710002 * this.sinio;
            this.satrec.nevalues.delmo = Math.pow(1.0 + this.satrec.nevalues.eta * Math.cos(this.satrec.mo), 3.0);
            this.satrec.nevalues.sinmao = Math.sin(this.satrec.mo);
            this.satrec.nevalues.x7thm1 = 7.0 * this.cosio2 - 1.0;
            this.satrec.init = 0;
            if (Math.PI * 2 / this.satrec.no >= 225.0) {
                this.satrec.nevalues.method = 2;
                this.satrec.nevalues.isimp = 1;
                d15 = 0.0;
                this.inclm = this.satrec.inclo;
                this.dscom(d, this.satrec.ecco, this.satrec.argpo, d15, this.satrec.inclo, this.satrec.omegao, this.satrec.no);
                this.satrec.mp = this.satrec.mo;
                this.satrec.argpp = this.satrec.argpo;
                this.satrec.ep = this.satrec.ecco;
                this.satrec.omegap = this.satrec.omegao;
                this.satrec.xincp = this.satrec.inclo;
                this.dpper(this.satrec.dsvalues.e3, this.satrec.dsvalues.ee2, this.satrec.dsvalues.se2, this.satrec.dsvalues.se3, this.satrec.dsvalues.sgh2, this.satrec.dsvalues.sgh3, this.satrec.dsvalues.sgh4, this.satrec.dsvalues.sh2, this.satrec.dsvalues.sh3, this.satrec.dsvalues.si2, this.satrec.dsvalues.si3, this.satrec.dsvalues.sl2, this.satrec.dsvalues.sl3, this.satrec.dsvalues.sl4, this.satrec.nevalues.t, this.satrec.dsvalues.xgh2, this.satrec.dsvalues.xgh3, this.satrec.dsvalues.xgh4, this.satrec.dsvalues.xh2, this.satrec.dsvalues.xh3, this.satrec.dsvalues.xi2, this.satrec.dsvalues.xi3, this.satrec.dsvalues.xl2, this.satrec.dsvalues.xl3, this.satrec.dsvalues.xl4, this.satrec.dsvalues.zmol, this.satrec.dsvalues.zmos, true);
                this.satrec.mo = this.satrec.mp;
                this.satrec.argpo = this.satrec.argpp;
                this.satrec.ecco = this.satrec.ep;
                this.satrec.omegao = this.satrec.omegap;
                this.satrec.inclo = this.satrec.xincp;
                this.argpm = 0.0;
                this.omegam = 0.0;
                this.mm = 0.0;
                this.dsinit(this.cosim, this.emsq, this.satrec.argpo, this.s1, this.s2, this.s3, this.s4, this.s5, this.sinim, this.satrec.nevalues.t, d15, this.satrec.dsvalues.gsto, this.satrec.mo, this.satrec.nevalues.mdot, this.satrec.no, this.satrec.omegao, this.satrec.nevalues.omegadot, d20, this.z1, this.z3, this.z11, this.z13, this.z21, this.z23, this.z31, this.z33, this.satrec.ecco, this.eccsq);
            }
            if (this.satrec.nevalues.isimp != 1) {
                d2 = this.satrec.nevalues.cc1 * this.satrec.nevalues.cc1;
                this.satrec.nevalues.d2 = 4.0 * this.ao * d19 * d2;
                double d24 = this.satrec.nevalues.d2 * d19 * this.satrec.nevalues.cc1 / 3.0;
                this.satrec.nevalues.d3 = (17.0 * this.ao + d14) * d24;
                this.satrec.nevalues.d4 = 0.5 * d24 * this.ao * d19 * (221.0 * this.ao + 31.0 * d14) * this.satrec.nevalues.cc1;
                this.satrec.nevalues.t3cof = this.satrec.nevalues.d2 + 2.0 * d2;
                this.satrec.nevalues.t4cof = 0.25 * (3.0 * this.satrec.nevalues.d3 + this.satrec.nevalues.cc1 * (12.0 * this.satrec.nevalues.d2 + 10.0 * d2));
                this.satrec.nevalues.t5cof = 0.2 * (3.0 * this.satrec.nevalues.d4 + 12.0 * this.satrec.nevalues.cc1 * this.satrec.nevalues.d3 + 6.0 * this.satrec.nevalues.d2 * this.satrec.nevalues.d2 + 15.0 * d2 * (2.0 * this.satrec.nevalues.d2 + d2));
            }
        }
    }

    public void twoline2rv(SatElset satElset) throws ObjectDecayed {
        this.satrec.error = 0;
        this.satrec.satnum = satElset.getSatID();
        String string = satElset.getIntDesig();
        this.satrec.intDesgination = string != null ? string.substring(0, 2) + "-" + string.substring(2, 5) + "-" + string.substring(5, 8) : "";
        this.satrec.epochyr = satElset.getEpochYr();
        this.satrec.epochdays = satElset.getEpochDay();
        this.satrec.bstar = satElset.getBstar();
        this.satrec.inclo = satElset.getInclinationDeg();
        this.satrec.omegao = satElset.getRightAscensionDeg();
        this.satrec.ecco = satElset.getEccentricity();
        this.satrec.argpo = satElset.getArgPerigeeDeg();
        this.satrec.mo = satElset.getMeanAnomalyDeg();
        this.satrec.no = satElset.getMeanMotion();
        this.satrec.no /= 229.1831180523293;
        this.satrec.a = Math.pow(this.satrec.no * GravConstants.tumin, -0.6666666666666666);
        this.satrec.inclo /= 57.2957795130823;
        this.satrec.omegao /= 57.2957795130823;
        this.satrec.argpo /= 57.2957795130823;
        this.satrec.mo /= 57.2957795130823;
        int n = this.satrec.epochyr + (this.satrec.epochyr < 50 ? 2000 : 1900);
        this.satrec.eptime = (double)((n - 1950) * 365 + (n - 1949) / 4) + this.satrec.epochdays;
        int n2 = (int)Math.floor(this.satrec.epochdays);
        double d = this.satrec.epochdays - (double)n2;
        int n3 = (int)Math.floor(d * 24.0);
        d = d * 24.0 - (double)n3;
        int n4 = (int)Math.floor(d * 60.0);
        d = d * 60.0 - (double)n4;
        double d2 = d * 60.0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.tz);
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(6, n2);
        gregorianCalendar.set(11, n3);
        gregorianCalendar.set(12, n4);
        double d3 = this.julianday(n, gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), n3, n4, d2) - 2400000.5;
        this.satrec.init = 1;
        this.satrec.nevalues.t = 0.0;
        this.sgp4init(this.satrec.satnum, n, d3 - 33281.0);
    }

    public String getIntDesig() {
        return this.satrec.intDesgination;
    }

    public static final class GravConstants
    extends GravConstantsWGS84 {
    }

    static class GravConstantsWGS84 {
        public static final double mu = 398600.5;
        public static final double radiusearthkm = 6378.137;
        public static final double xke = 60.0 / Math.sqrt(650944.0944816993);
        public static final double tumin = 1.0 / xke;
        public static final double j2 = 0.00108262998905;
        public static final double j3 = -2.53215306E-6;
        public static final double j4 = -1.61098761E-6;
        public static final double j3oj2 = -0.0023388905587420003;

        GravConstantsWGS84() {
        }
    }

    static class GravConstantsWGS72 {
        public static final double mu = 398600.8;
        public static final double radiusearthkm = 6378.135;
        public static final double xke = 60.0 / Math.sqrt(650942.9922085947);
        public static final double tumin = 1.0 / xke;
        public static final double j2 = 0.001082616;
        public static final double j3 = -2.53881E-6;
        public static final double j4 = -1.65597E-6;
        public static final double j3oj2 = -0.002345069720011528;

        GravConstantsWGS72() {
        }
    }

    public class ObjectDecayed
    extends SatElsetException {
        private static final long serialVersionUID = 1230517552210764538L;

        public ObjectDecayed() {
        }

        public ObjectDecayed(String string) {
            super(string);
        }
    }
}

