/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.sgp4v;

import com.lavadip.skeye.astro.sgp4v.SatElsetException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class SatElset
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final String BLANKCARD = "                                                                     ";
    private double argPerigee;
    private double bstar;
    private double eccentricity;
    private int elsetNum;
    private int ephemerisType;
    private double epochDay;
    private int epochYr;
    private double inclination;
    private String intDesig;
    private boolean isValid;
    private double meanAnomaly;
    private double meanMotion;
    private String name;
    private int revNum;
    private double rightAscension;
    private String satClass;
    private int satID;
    private static final double TODEGREES = 57.29577951308232;
    private static final double TORADIANS = Math.PI / 180;

    public SatElset() {
        this.name = " ";
        this.isValid = false;
    }

    public SatElset(SatElset satElset) {
        this.name = new String(satElset.getName());
        if (this.name == null) {
            this.name = " ";
        }
        this.argPerigee = satElset.argPerigee;
        this.bstar = satElset.bstar;
        this.eccentricity = satElset.eccentricity;
        this.elsetNum = satElset.elsetNum;
        this.ephemerisType = satElset.ephemerisType;
        this.epochDay = satElset.epochDay;
        this.epochYr = satElset.epochYr;
        this.inclination = satElset.inclination;
        this.intDesig = satElset.intDesig;
        this.meanAnomaly = satElset.meanAnomaly;
        this.meanMotion = satElset.meanMotion;
        this.revNum = satElset.revNum;
        this.rightAscension = satElset.rightAscension;
        this.satClass = satElset.satClass;
        this.satID = satElset.satID;
    }

    public SatElset(String string, String string2) throws SatElsetException {
        this(" ", string, string2);
    }

    public SatElset(String string, String string2, String string3) throws SatElsetException {
        this.name = string == null ? " " : new String(string);
        int n = string2.length();
        if (n <= 69) {
            string2 = string2 + BLANKCARD.substring(0, 69 - n);
        }
        String string4 = string2.substring(0, Math.min(string2.length(), 69));
        n = string3.length();
        if (n <= 69) {
            string3 = string3 + BLANKCARD.substring(0, 69 - n);
        }
        String string5 = string3.substring(0, Math.min(string3.length(), 69));
        try {
            this.isValid = this.card1IsValid(string4) && this.card2IsValid(string5) && string4.regionMatches(2, string5, 2, 5);
        }
        catch (Exception exception) {
            String string6 = exception.toString() + "\nSatElset constructor Invalid elset:\nCard1: [" + string4 + "]\nCard2: [" + string5 + "]";
            throw new SatElsetException(string6);
        }
    }

    public boolean card1IsValid(String string) throws SatElsetException, ValueOutOfRangeException {
        String string2;
        Object object;
        if (string == null) {
            throw new SatElsetException("SatElset.card1IsValid Card 1 is null");
        }
        if (string.length() < 68) {
            throw new SatElsetException("SatElset.card1IsValid Card 1 length < 68 length = " + string.length());
        }
        if (!"1".equals(string.substring(0, 1))) {
            throw new SatElsetException("SatElset.card1IsValid Card 1 not 1: [" + string + "]");
        }
        try {
            this.satID = Integer.parseInt(string.substring(2, 7).replace(' ', '0'));
            if (this.satID < 1 || this.satID > 99999) {
                throw new ValueOutOfRangeException("SatElset.card1IsValid Card 1 satID number out of range *" + string.substring(2, 7) + "*");
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = "SatElset.card1IsValid Card 1 satID number format exception *" + string.substring(2, 7) + "*";
            String string4 = "SatElset.card1IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string3 + "\\n" + string4);
        }
        this.satClass = string.substring(7, 8);
        if (!("U".equals(this.satClass) || "C".equals(this.satClass) || "S".equals(this.satClass) || "T".equals(this.satClass))) {
            throw new SatElsetException("SatElset.card1IsValid Card 1 classification error: [" + string.charAt(7) + "]");
        }
        this.intDesig = string.substring(9, 17);
        try {
            this.epochYr = Integer.parseInt(string.substring(18, 20));
            if (this.epochYr < 0 || this.epochYr > 99) {
                throw new ValueOutOfRangeException("SatElset.card1IsValid Card 1 epochYr out of range: [" + string.substring(18, 20) + "]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string5 = "SatElset.card1IsValid Card 1 epochYr number format exception: [" + string.substring(18, 20) + "]  Satellite number: " + this.satID;
            String string6 = "SatElset.card1IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string5 + "\\n" + string6);
        }
        try {
            this.epochDay = Double.valueOf(string.substring(20, 32));
            if (this.epochDay < 0.0 || this.epochDay > 367.0) {
                throw new ValueOutOfRangeException("SatElset.card1IsValid Card 1 epochDay out of range: [" + string.substring(20, 32) + "]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string7 = "SatElset.card1IsValid Card 1 epochDay number format exception: [" + string.substring(20, 32) + "]  Satellite number: " + this.satID;
            String string8 = "SatElset.card1IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string7 + "\\n" + string8);
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int n = (int)this.epochDay;
        double d = (this.epochDay - (double)n) * 86400.0;
        int n2 = (int)(d / 3600.0);
        int n3 = (int)((d - (double)n2 * 3600.0) / 60.0);
        int n4 = (int)(d - (double)(n2 * 3600 + n3 * 60));
        int n5 = (int)((d - (double)((int)d)) * 1000.0);
        calendar.set(1, (this.epochYr + 50) % 100 + 1950);
        calendar.set(6, n);
        calendar.set(11, n2);
        calendar.set(12, n3);
        calendar.set(13, n4);
        calendar.set(14, n5);
        try {
            object = string.charAt(50) == ' ' ? string.substring(44, 45) + "." + string.substring(45, 50) + "E+" + string.substring(51, 52) : string.substring(44, 45) + "." + string.substring(45, 50) + "E" + string.substring(50, 52);
        }
        catch (NumberFormatException numberFormatException) {
            String string9 = "SatElset.card1IsValid Invalid NdotDot for Satellite number: " + this.satID + " [" + string.substring(44, 52) + "]";
            String string10 = "SatElset.card1IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string9 + "\\n" + string10);
        }
        try {
            object = string.substring(59, 61);
            string2 = " 0".equalsIgnoreCase((String)object) ? "00" : object;
            this.bstar = Double.valueOf(string.substring(53, 54) + "." + string.substring(54, 59) + "E" + string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string11 = "SatElset.card1IsValid Invalid BSTAR for Satellite number: " + this.satID + " [" + string.substring(53, 61) + "]";
            String string12 = "SatElset.card1IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string11 + "\\n" + string12);
        }
        try {
            if (" ".equals(string.substring(62, 63))) {
                object = "SatElset.card1IsValid No Ephemeris Type for Satellite number: " + this.satID + " [" + string.substring(62, 63) + "], Set to 0";
                throw new SatElsetException((String)object);
            }
            this.ephemerisType = Integer.parseInt(string.substring(62, 63));
            if (this.ephemerisType != 0 && this.ephemerisType != 2) {
                throw new ValueOutOfRangeException("SatElset.card1IsValid Card 1 ephemerisType out of range: [" + string.substring(62, 63) + "]  Satellite number: " + this.satID);
            }
        }
        catch (NumberFormatException numberFormatException) {
            string2 = "SatElset.card1IsValid Card 1 ephemerisType number format exception: [" + string.substring(62, 63) + "]  Satellite number: " + this.satID;
            String string13 = "SatElset.card1IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string2 + "\\n" + string13);
        }
        object = new StringTokenizer(string.substring(65, 68), " ");
        try {
            this.elsetNum = Integer.parseInt((String)((StringTokenizer)object).nextElement());
            if (this.elsetNum < 0 || this.elsetNum > 999) {
                string2 = "SatElset.card1IsValid Card 1 elsetNum number out of range: [" + string.substring(65, 68) + "]";
                throw new ValueOutOfRangeException(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string14 = "SatElset.card1IsValid Card 1 elsetNum number format exception: [" + string.substring(65, 68) + "]  Satellite number: " + this.satID;
            String string15 = "SatElset.card1IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string14 + "\\n" + string15);
        }
        if (string.length() > 68 && !" ".equals(string.substring(68, 69)) && this.checkSum(string) != Integer.parseInt(string.substring(68, 69))) {
            string2 = "SatElset.card1IsValid Check Sum error on Card 1. Expecting: " + this.checkSum(string) + " Actual value on card: " + Integer.parseInt(string.substring(68, 69)) + " Satellite number: " + this.satID;
            throw new SatElsetException(string2);
        }
        return true;
    }

    public boolean card2IsValid(String string) throws SatElsetException, ValueOutOfRangeException {
        double d;
        int n = 0;
        if (string == null) {
            return false;
        }
        if (string.length() < 68) {
            return false;
        }
        if (!"2".equals(string.substring(0, 1))) {
            return false;
        }
        try {
            n = Integer.parseInt(string.substring(2, 7).replace(' ', '0'));
            if (n < 1 || n > 99999) {
                String string2 = "SatElset.card2IsValid Card 2 satID number out of range: [" + string.substring(2, 7) + "]";
                throw new ValueOutOfRangeException(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = "SatElset.card2IsValid Card 2 satID number format exception: [" + string.substring(2, 7) + "]";
            String string4 = "SatElset.card2IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string3 + "\\n" + string4);
        }
        try {
            d = Double.valueOf(string.substring(8, 17));
            if (d < 0.0 || d > 180.0) {
                String string5 = "SatElset.card2IsValid Card 2 inclination out of range: [" + string.substring(8, 17) + "]  Satellite number: " + n;
                throw new ValueOutOfRangeException(string5);
            }
            this.inclination = d * (Math.PI / 180);
        }
        catch (NumberFormatException numberFormatException) {
            String string6 = "SatElset.card2IsValid Card 2 inclination number format exception: [" + string.substring(8, 17) + "]  Satellite number: " + n;
            String string7 = "SatElset.card2IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string6 + "\\n" + string7);
        }
        try {
            d = Double.valueOf(string.substring(17, 26));
            if (d < 0.0 || d > 360.0) {
                String string8 = "SatElset.card2IsValid Card 2 rightAcension out of range: [" + string.substring(17, 26) + "]  Satellite number: " + n;
                throw new ValueOutOfRangeException(string8);
            }
            this.rightAscension = d * (Math.PI / 180);
        }
        catch (NumberFormatException numberFormatException) {
            String string9 = "SatElset.card2IsValid Card 2 rightAcension number format exception: [" + string.substring(17, 26) + "]  Satellite number: " + n;
            String string10 = "SatElset.card2IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string9 + "\\n" + string10);
        }
        try {
            d = Double.valueOf(string.substring(34, 42));
            if (d < 0.0 || d > 360.0) {
                String string11 = "SatElset.card2IsValid Card 2 argPerigee out of range: [" + string.substring(34, 42) + "]  Satellite number: " + n;
                throw new ValueOutOfRangeException(string11);
            }
            this.argPerigee = d * (Math.PI / 180);
        }
        catch (NumberFormatException numberFormatException) {
            String string12 = "SatElset.card2IsValid Card 2 argPerigee number format exception: [" + string.substring(34, 42) + "]  Satellite number: " + n;
            String string13 = "SatElset.card2IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string12 + "\\n" + string13);
        }
        try {
            d = Double.valueOf("0." + string.substring(26, 33));
            if (d < 0.0 || d >= 1.0) {
                String string14 = "SatElset.card2IsValid Card 2 eccentricity out of range: [0." + string.substring(26, 33) + "]  Satellite number: " + n;
                throw new ValueOutOfRangeException(string14);
            }
            this.eccentricity = d;
        }
        catch (NumberFormatException numberFormatException) {
            String string15 = "SatElset.card2IsValid Card 2 eccentricity number format exception: [0." + string.substring(26, 33) + "]  Satellite number: " + n;
            String string16 = "SatElset.card2IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string15 + "\\n" + string16);
        }
        try {
            d = Double.valueOf(string.substring(43, 51));
            if (d < 0.0 || d > 360.0) {
                String string17 = "SatElset.card2IsValid Card 2 meanAnomaly out of range: [" + string.substring(43, 51) + "]  Satellite number: " + n;
                throw new ValueOutOfRangeException(string17);
            }
            this.meanAnomaly = d * (Math.PI / 180);
        }
        catch (NumberFormatException numberFormatException) {
            String string18 = "SatElset.card2IsValid Card 2 meanAnomaly number format exception: [" + string.substring(43, 51) + "]  Satellite number: " + n;
            String string19 = "SatElset.card2IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string18 + "\\n" + string19);
        }
        try {
            this.meanMotion = Double.valueOf(string.substring(52, 63));
            if (this.meanMotion > 17.0) {
                String string20 = "SatElset.card2IsValid Card 2 meanMotion out of range: [" + string.substring(52, 63) + "]  Satellite number: " + n;
                throw new ValueOutOfRangeException(string20);
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string21 = "SatElset.card2IsValid Card 2 meanMotion number format exception: [" + string.substring(52, 63) + "]  Satellite number: " + n;
            String string22 = "SatElset.card2IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string21 + "\\n" + string22);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(63, 68), " ");
        try {
            this.revNum = Integer.parseInt((String)stringTokenizer.nextElement());
        }
        catch (NumberFormatException numberFormatException) {
            String string23 = "SatElset.card2IsValid Card 2 revNum number format exception: [" + string.substring(63, 68) + "]  Satellite number: " + n;
            String string24 = "SatElset.card2IsValid [" + numberFormatException + "]";
            throw new SatElsetException(string23 + "\\n" + string24);
        }
        if (this.revNum < 0 || this.revNum > 99999) {
            String string25 = "SatElset.card2IsValid Card 2 revNum out of range: [" + string.substring(52, 63) + "]  Satellite number: " + n;
            throw new ValueOutOfRangeException(string25);
        }
        if (string.length() > 68 && !" ".equals(string.substring(68, 69)) && this.checkSum(string) != Integer.parseInt(string.substring(68, 69))) {
            String string26 = "SatElset.card2IsValid Check Sum error on Card 2. Expecting: " + this.checkSum(string) + " Actual value on card: " + Integer.parseInt(string.substring(68, 69)) + " Satellite number: " + n;
            throw new SatElsetException(string26);
        }
        return true;
    }

    private int checkSum(String string) {
        int n = 0;
        block11: for (int i = 0; i < 68; ++i) {
            switch (string.charAt(i)) {
                case '-': 
                case '1': {
                    ++n;
                    continue block11;
                }
                case '2': {
                    n += 2;
                    continue block11;
                }
                case '3': {
                    n += 3;
                    continue block11;
                }
                case '4': {
                    n += 4;
                    continue block11;
                }
                case '5': {
                    n += 5;
                    continue block11;
                }
                case '6': {
                    n += 6;
                    continue block11;
                }
                case '7': {
                    n += 7;
                    continue block11;
                }
                case '8': {
                    n += 8;
                    continue block11;
                }
                case '9': {
                    n += 9;
                    continue block11;
                }
            }
        }
        return n % 10;
    }

    public boolean equals(SatElset satElset) {
        return false;
    }

    public double getArgPerigee() {
        return this.argPerigee;
    }

    public double getArgPerigeeDeg() {
        return this.argPerigee * 57.29577951308232;
    }

    public double getEccentricity() {
        return this.eccentricity;
    }

    public int getElsetNum() {
        return this.elsetNum;
    }

    public int getEphemerisType() {
        return this.ephemerisType;
    }

    public double getBstar() {
        return this.bstar;
    }

    public double getEpochDay() {
        return this.epochDay;
    }

    public int getEpochYr() {
        return this.epochYr;
    }

    public double getInclination() {
        return this.inclination;
    }

    public double getInclinationDeg() {
        return this.inclination * 57.29577951308232;
    }

    public String getIntDesig() {
        return this.intDesig;
    }

    public double getMeanAnomaly() {
        return this.meanAnomaly;
    }

    public double getMeanAnomalyDeg() {
        return this.meanAnomaly * 57.29577951308232;
    }

    public double getMeanMotion() {
        return this.meanMotion;
    }

    public String getName() {
        return this.name;
    }

    public double getPeriod() {
        double d = this.getMeanMotion();
        if (d > 0.0) {
            return 1440.0 / d;
        }
        return 0.0;
    }

    public int getRevNum() {
        return this.revNum;
    }

    public double getRightAscension() {
        return this.rightAscension;
    }

    public double getRightAscensionDeg() {
        return this.rightAscension * 57.29577951308232;
    }

    public int getSatID() {
        return this.satID;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public class ValueOutOfRangeException
    extends Exception {
        private static final long serialVersionUID = 7729000960933265858L;

        public ValueOutOfRangeException() {
        }

        public ValueOutOfRangeException(String string) {
            super(string);
        }
    }
}

