/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.keplerian;

import com.lavadip.skeye.AstroUtil;
import com.lavadip.skeye.Vector2d;
import com.lavadip.skeye.astro.Instant;
import com.lavadip.skeye.astro.keplerian.Elements;
import com.lavadip.skeye.astro.keplerian.Orbit;

public final class ParabolicOrbit
extends Orbit {
    private static final double THREE_PI = Math.PI * 3;
    private static final double SQUARE_ROOT_TWO = Math.sqrt(2.0);
    private static final double THREE_PI_SQUARE_ROOT_TWO = Math.PI * 3 * SQUARE_ROOT_TWO;

    public ParabolicOrbit(Elements elements) {
        super(elements);
    }

    @Override
    public Vector2d getPolarPosition(Instant instant) {
        double d = this.elems.periapsisDistance;
        double d2 = Math.sqrt(Math.pow(d, 3.0));
        double d3 = 2.0 * d;
        double d4 = this.elems.epochPeriapsis.getSiderealYears();
        double d5 = instant.getSiderealYears();
        final double d6 = THREE_PI_SQUARE_ROOT_TWO * (d5 - d4) / d2;
        AstroUtil.DeltaFunction deltaFunction = new AstroUtil.DeltaFunction(){

            @Override
            public double apply(double d) {
                double d2 = d * d;
                double d3 = 2.0 * d2 * d + d6;
                double d4 = 3.0 * (1.0 + d2);
                return d3 / d4;
            }
        };
        double d7 = AstroUtil.newtonRaphson(Math.PI, deltaFunction, 50, 1.0E-12);
        double d8 = d6 < 0.0 ? -2.0 * Math.atan(d7) : 2.0 * Math.atan(d7);
        double d9 = d3 / (1.0 + Math.cos(d8));
        return new Vector2d(d8, d9);
    }
}

