/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.keplerian;

import com.lavadip.skeye.Vector2d;
import com.lavadip.skeye.Vector3d;
import com.lavadip.skeye.astro.Instant;
import com.lavadip.skeye.astro.keplerian.Elements;
import com.lavadip.skeye.astro.keplerian.EllipticalOrbit;

public abstract class Orbit {
    public final Elements elems;
    private static Instant J2000 = new Instant(2000, 1, 1, 0.5);
    public static final Orbit sunOrbit = new Orbit(null){

        @Override
        public Vector2d getPolarPosition(Instant instant) {
            return null;
        }

        @Override
        public Vector3d getHeliocentricPosition(Instant instant) {
            return new Vector3d(0.0f, 0.0f, 0.0f);
        }
    };
    private static final double earthSemiMajorAxix = 1.00000011;
    private static final double earthEccentricity = 0.01671022;
    public static final Orbit earthOrbit = new EllipticalOrbit(new Elements(new Instant(2000, 1, 4, 0.0), 0.9832898881618758, 0.0, 0.01671022, Math.toRadians(5.0E-5), Math.toRadians(-11.26064), Math.toRadians(114.20783)));

    public Orbit(Elements elements) {
        this.elems = elements;
    }

    public abstract Vector2d getPolarPosition(Instant var1);

    public Vector3d getHeliocentricPosition(Instant instant) {
        Vector2d vector2d = this.getPolarPosition(instant);
        double d = vector2d.x;
        double d2 = vector2d.y;
        double d3 = this.elems.argOfPeriapsis + d;
        double d4 = this.elems.longitudeOfAscendingNode;
        double d5 = this.elems.inclination;
        double d6 = Math.sin(d4);
        double d7 = Math.cos(d4);
        double d8 = Math.sin(d3);
        double d9 = Math.cos(d3);
        double d10 = Math.sin(d5);
        double d11 = Math.cos(d5);
        double d12 = d2 * (d9 * d7 - d8 * d6 * d11);
        double d13 = d2 * (d9 * d6 + d8 * d7 * d11);
        double d14 = d2 * (d8 * d10);
        return new Vector3d(d12, d13, d14);
    }

    public OrbitInstantData getGeoentricPosition(Instant instant) {
        return this.getGeoentricPosition(instant, J2000);
    }

    public OrbitInstantData getGeoentricPosition(Instant instant, Instant instant2) {
        Vector3d vector3d = this.getHeliocentricPosition(instant);
        Vector3d vector3d2 = earthOrbit.getHeliocentricPosition(instant);
        Vector3d vector3d3 = vector3d.sub(vector3d2);
        double d = vector3d3.length();
        double d2 = this.obliqnessOfEcliptic(instant2);
        Vector3d vector3d4 = vector3d3.rotateAboutXaxis(d2);
        return new OrbitInstantData(this.normaliseRA(Math.atan2(vector3d4.y, vector3d4.x)), Math.atan2(vector3d4.z, Math.sqrt(vector3d4.x * vector3d4.x + vector3d4.y * vector3d4.y)), vector3d.length(), d);
    }

    private double normaliseRA(double d) {
        return d < 0.0 ? d + Math.PI * 2 : d;
    }

    private double obliqnessOfEcliptic(Instant instant) {
        double d = instant.getDaysJ2000();
        return Math.toRadians(23.4393 - 3.563E-7 * d);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.elems == null ? 0 : this.elems.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Orbit orbit = (Orbit)object;
        return !(this.elems == null ? orbit.elems != null : !this.elems.equals(orbit.elems));
    }

    public static class OrbitInstantData {
        public final double RA;
        public final double Dec;
        public final double heliocentricDistance;
        public final double geocentricDistance;

        public OrbitInstantData(double d, double d2, double d3, double d4) {
            this.RA = d;
            this.Dec = d2;
            this.heliocentricDistance = d3;
            this.geocentricDistance = d4;
        }
    }
}

