/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.keplerian;

import com.lavadip.skeye.AstroUtil;
import com.lavadip.skeye.Vector2d;
import com.lavadip.skeye.astro.Instant;
import com.lavadip.skeye.astro.keplerian.Elements;
import com.lavadip.skeye.astro.keplerian.Orbit;

public final class HyperbolicOrbit
extends Orbit {
    public HyperbolicOrbit(Elements elements) {
        super(elements);
    }

    @Override
    public Vector2d getPolarPosition(Instant instant) {
        final double d = this.elems.eccentricity;
        assert (d > 1.0);
        double d2 = d * d;
        double d3 = this.elems.periapsisDistance / (d - 1.0);
        double d4 = Math.sqrt(Math.pow(d3, 3.0));
        double d5 = d3 * (d2 - 1.0);
        double d6 = this.elems.epochPeriapsis.getSiderealYears();
        double d7 = instant.getSiderealYears();
        final double d8 = Math.PI * 2 * (d7 - d6) / d4;
        AstroUtil.DeltaFunction deltaFunction = new AstroUtil.DeltaFunction(){

            @Override
            public double apply(double d5) {
                double d2 = Math.cosh(d5);
                double d3 = d8 + d * (d5 * d2 - Math.sinh(d5));
                double d4 = d * d2 - 1.0;
                return d3 / d4;
            }
        };
        double d9 = AstroUtil.newtonRaphson(Math.PI, deltaFunction, 50, 1.0E-12);
        double d10 = Math.cosh(d9);
        double d11 = Math.acos((d - d10) / (d * d10 - 1.0));
        double d12 = d7 > d6 ? d11 : -d11;
        double d13 = d5 / (1.0 + d * Math.cos(d12));
        return new Vector2d(d12, d13);
    }
}

