/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.keplerian;

import com.lavadip.skeye.AstroUtil;
import com.lavadip.skeye.Vector2d;
import com.lavadip.skeye.astro.Instant;
import com.lavadip.skeye.astro.keplerian.Elements;
import com.lavadip.skeye.astro.keplerian.Orbit;

public final class EllipticalOrbit
extends Orbit {
    @Override
    public Vector2d getPolarPosition(Instant instant) {
        final double d = this.elems.eccentricity;
        assert (d < 1.0);
        double d2 = this.elems.periapsisDistance / (1.0 - d);
        double d3 = Math.sqrt(Math.pow(d2, 3.0));
        double d4 = d2 * (1.0 - d * d);
        double d5 = this.elems.epochPeriapsis.getSiderealYears();
        double d6 = instant.getSiderealYears();
        final double d7 = this.elems.meanAnomalyAtEpoch + Math.PI * 2 * (d6 - d5) / d3;
        AstroUtil.DeltaFunction deltaFunction = new AstroUtil.DeltaFunction(){

            @Override
            public double apply(double d4) {
                double d2 = d4 - d * Math.sin(d4) - d7;
                double d3 = 1.0 - d * Math.cos(d4);
                return d4 - d2 / d3;
            }
        };
        double d8 = AstroUtil.newtonRaphson(Math.PI, deltaFunction, 50, 1.0E-12);
        double d9 = Math.sqrt((1.0 + d) / (1.0 - d));
        double d10 = 2.0 * Math.atan2(d9 * Math.sin(d8 / 2.0), Math.cos(d8 / 2.0));
        double d11 = d4 / (1.0 + d * Math.cos(d10));
        return new Vector2d(d10, d11);
    }

    public EllipticalOrbit(Elements elements) {
        super(elements);
    }
}

