/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.ephemeris;

import com.lavadip.skeye.astro.ephemeris.Ephemeris;
import com.lavadip.skeye.astro.ephemeris.LoLa;
import com.lavadip.skeye.astro.ephemeris.MajorPlanet;
import com.lavadip.skeye.astro.ephemeris.Pol2;
import com.lavadip.skeye.astro.ephemeris.Rect3;
import java.util.Date;

public final class Utils {
    private static final double JD_1970_JAN_1 = 2440587.5;
    private static final short[] dt = new short[]{1240, 1020, 850, 720, 620, 540, 480, 430, 370, 320, 260, 210, 160, 120, 100, 90, 90, 90, 100, 100, 110, 110, 110, 120, 120, 130, 130, 140, 150, 160, 160, 170, 170, 170, 170, 160, 137, 126, 125, 125, 120, 102, 75, 58, 57, 63, 71, 76, 79, 60, 16, -32, -54, -58, -59, -65, -27, 39, 105, 172, 212, 236, 240, 239, 243, 268, 292, 311, 332, 357, 402, 455, 505, 543, 569, 608, 660, 710, 750, 790, 830, 870, 910, 950, 990, 1030, 1070, 1110, 1150, 1190, 1230, 1270, 1310, 1350, 1390, 1430, 1470, 1510, 1550, 1590, 1630, 1670, 1710, 1750, 1790, 1830, 1870, 1910, 1950, 1990, 2030, 2070, 2110, 2150, 2190, 2230, 2270};
    private static final int YSTART = 1620;
    private static final int YEND = 2200;
    private static final double RADEG = 45.0 / Math.atan(1.0);
    private static final double EPSILON = 3.0E-8;
    private static final double INFINITY = 1.0E10;
    public static final double AU_IN_KM = 1.495978707E8;
    public static final double SunMeanR = 0.0046491;
    public static final double MoonMeanR = 1.1614E-5;
    public static final double EarthR = 4.263496512454038E-5;
    public static final double JupiterMeanR = 4.6732617030490934E-4;
    public static final double JupiterEquatorialR = 4.7789450254521576E-4;
    public static final double JupiterPolarR = 4.468913874721347E-4;
    static final double yday = 2.7379092633269358E-5;

    static double JD(Date date) {
        long l = date.getTime();
        return 2440587.5 + (double)l / 8.64E7;
    }

    public static double JED(Date date) {
        double d = Utils.JD(date);
        double d2 = d + Utils.DTT(d) / 360.0;
        return d2;
    }

    static double DTT(double d) {
        double d2 = (d - 2451545.0) / 365.25 + 2000.0;
        if (d2 >= 1620.0 && d2 <= 2200.0) {
            int n = (int)Math.floor((d2 - 1620.0) / 5.0);
            double d3 = (d2 - 1620.0 - (double)(5 * n)) * 0.2;
            return ((double)dt[n] * (1.0 - d3) + (double)dt[n + 1] * d3) / 2400.0;
        }
        double d4 = (d2 - 1900.0) / 100.0;
        return 0.1025 + 0.301325 * d4 + 0.1248 * d4 * d4;
    }

    static double rev180(double d) {
        return d - 360.0 * Math.floor(d / 360.0 + 0.5);
    }

    static double rev360(double d) {
        return d - 360.0 * Math.floor(d / 360.0);
    }

    static double frac(double d) {
        return d - Math.floor(d);
    }

    static double sind(double d) {
        return Math.sin(d / RADEG);
    }

    static double cosd(double d) {
        return Math.cos(d / RADEG);
    }

    static double atan2d(double d, double d2) {
        return Math.atan2(d, d2) * RADEG;
    }

    static Rect3 helpos(double d, double d2, double d3, double d4, double d5) {
        double d6 = d + d3;
        double d7 = Utils.sind(d6);
        double d8 = Utils.cosd(d6);
        double d9 = Utils.sind(d4);
        double d10 = Utils.cosd(d4);
        double d11 = Utils.sind(d5);
        double d12 = Utils.cosd(d5);
        double d13 = d2 * (d12 * d8 - d11 * d7 * d10);
        double d14 = d2 * (d11 * d8 + d12 * d7 * d10);
        double d15 = d2 * (d7 * d9);
        return new Rect3(d13, d14, d15);
    }

    static double kepler(double d, double d2) {
        double d3 = Utils.rev180(d);
        double d4 = Utils.sind(d3);
        double d5 = Utils.cosd(d3);
        double d6 = Utils.atan2d(d4, d5 - d2);
        if (d2 > 0.008) {
            boolean bl;
            double d7 = d2 * RADEG;
            double d8 = 0.001 / d2;
            double d9 = 1.0E10;
            double d10 = 1.0 - d2 * Utils.cosd(d6);
            do {
                double d11 = (d3 + d7 * Utils.sind(d6) - d6) / d10;
                d6 += d11;
                double d12 = Math.abs(d11);
                bl = d12 < 3.0E-8 || d12 >= d9;
                d9 = d12;
                if (bl || !(d12 > d8)) continue;
                d10 = 1.0 - d2 * Utils.cosd(d6);
            } while (!bl);
        }
        return d6;
    }

    static Pol2 vr(double d, double d2, double d3) {
        double d4 = Utils.kepler(d, d2);
        double d5 = d3 * (Utils.cosd(d4) - d2);
        double d6 = d3 * Math.sqrt(1.0 - d2 * d2) * Utils.sind(d4);
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        double d8 = Utils.atan2d(d6, d5);
        return new Pol2(d8, d7);
    }

    static Rect3 P2R(MajorPlanet majorPlanet) {
        double d = Utils.cosd(majorPlanet.lon) * Utils.cosd(majorPlanet.lat) * majorPlanet.r;
        double d2 = Utils.sind(majorPlanet.lon) * Utils.cosd(majorPlanet.lat) * majorPlanet.r;
        double d3 = Utils.sind(majorPlanet.lat) * majorPlanet.r;
        return new Rect3(d, d2, d3);
    }

    static Rect3 R3sum(Rect3 rect3, Rect3 rect32) {
        double d = rect3.x + rect32.x;
        double d2 = rect3.y + rect32.y;
        double d3 = rect3.z + rect32.z;
        return new Rect3(d, d2, d3);
    }

    static Rect3 R3diff(Rect3 rect3, Rect3 rect32) {
        double d = rect3.x - rect32.x;
        double d2 = rect3.y - rect32.y;
        double d3 = rect3.z - rect32.z;
        return new Rect3(d, d2, d3);
    }

    static double sqsum(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    static double sqsum(double d, double d2, double d3) {
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    static Ephemeris.PlanetData eclequ(MajorPlanet majorPlanet, double d) {
        double d2 = Utils.sind(majorPlanet.lat);
        double d3 = Utils.cosd(majorPlanet.lat);
        double d4 = d3 * Utils.cosd(majorPlanet.lon);
        double d5 = d3 * Utils.sind(majorPlanet.lon);
        double d6 = Utils.cosd(d);
        double d7 = Utils.sind(d);
        double d8 = d5 * d7 + d2 * d6;
        double d9 = d5 * d6 - d2 * d7;
        double d10 = Utils.atan2d(d9, d4);
        double d11 = Utils.atan2d(d8, Math.sqrt(d4 * d4 + d9 * d9));
        double d12 = majorPlanet.r;
        return new Ephemeris.PlanetData(d10, d11, d12);
    }

    static double oblecl(double d) {
        return 23.4393 - 3.563E-7 * (d - 2451543.5);
    }

    static Ephemeris.PlanetData topocentric(Ephemeris.PlanetData planetData, double d, double d2, double d3) {
        double d4 = Utils.frac(d + 0.5) * 360.0;
        double d5 = 360.0 * Utils.frac(0.279072 + 0.00273790931 * (d - 2451545.0));
        double d6 = d5 + d4 + d2;
        double d7 = 4.263496512454038E-5 * Utils.cosd(d3);
        double d8 = d7 * Utils.cosd(d6);
        double d9 = d7 * Utils.sind(d6);
        double d10 = 4.263496512454038E-5 * Utils.sind(d3);
        Rect3 rect3 = new Rect3(d8, d9, d10);
        Rect3 rect32 = planetData.toRect3();
        Rect3 rect33 = Utils.R3diff(rect32, rect3);
        return rect33.toPlanetData();
    }

    static LoLa prec(double d, LoLa loLa, double d2) {
        double d3 = (d - 2415020.313) * 2.7379092633269358E-5;
        double d4 = (d2 - d) * 2.7379092633269358E-5;
        double d5 = d4 * ((5.0E-6 * d4 + 8.39E-5) * d4 + (0.6400694 + 3.878E-4 * d3));
        double d6 = d5 + d4 * d4 * (2.197E-4 + 3.0E-7 * d4);
        double d7 = d4 * ((-1.17E-5 * d4 - 1.183E-4) * d4 + (0.5568561 - 2.369E-4 * d3));
        double d8 = Utils.sind(loLa.lo + d5);
        double d9 = Utils.cosd(loLa.lo + d5);
        double d10 = Utils.sind(loLa.la);
        double d11 = Utils.cosd(loLa.la);
        double d12 = Utils.sind(d7);
        double d13 = Utils.cosd(d7);
        double d14 = d11 * d8;
        double d15 = d13 * d11 * d9 - d12 * d10;
        double d16 = d12 * d11 * d9 + d13 * d10;
        double d17 = Utils.atan2d(d14, d15) + d6;
        double d18 = Utils.atan2d(d16, Math.sqrt(d14 * d14 + d15 * d15));
        return new LoLa(d17, d18);
    }
}

