/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.ephemeris;

import com.lavadip.skeye.astro.ephemeris.Ephemeris;
import com.lavadip.skeye.astro.ephemeris.Utils;

final class Rect3 {
    final double x;
    final double y;
    final double z;

    public Rect3() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Rect3(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Ephemeris.PlanetData toPlanetData() {
        double d = Utils.atan2d(this.y, this.x);
        double d2 = Utils.atan2d(this.z, Math.sqrt(this.x * this.x + this.y * this.y));
        double d3 = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new Ephemeris.PlanetData(d, d2, d3);
    }

    public String toString() {
        return String.format("[%f, %f, %f] Length = %f", this.x, this.y, this.z, Utils.sqsum(this.x, this.y, this.z));
    }
}

