/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.ephemeris;

import com.lavadip.skeye.astro.ephemeris.Pol2;
import com.lavadip.skeye.astro.ephemeris.Rect3;
import com.lavadip.skeye.astro.ephemeris.Utils;

final class MajorPlanet {
    public final double lon;
    public final double lat;
    public final double r;

    private MajorPlanet(double d, double d2, double d3) {
        this.lon = d;
        this.lat = d2;
        this.r = d3;
    }

    static MajorPlanet Sun(double d) {
        double d2 = d - 2451545.0;
        double d3 = d2 / 36525.0 + 1.0;
        double d4 = 360.0 * Utils.frac(0.779072 + 0.00273790931 * d2);
        double d5 = 360.0 * Utils.frac(0.993126 + 0.0027377785 * d2);
        double d6 = 360.0 * Utils.frac(0.606434 + 0.03660110129 * d2);
        double d7 = d6 - d4;
        double d8 = 360.0 * Utils.frac(0.140023 + 0.00445036173 * d2);
        double d9 = 360.0 * Utils.frac(0.053856 + 0.00145561327 * d2);
        double d10 = 360.0 * Utils.frac(0.056531 + 2.3080893E-4 * d2);
        double d11 = Utils.sind(d5);
        double d12 = Utils.cosd(d5);
        double d13 = Utils.sind(d8);
        double d14 = Utils.cosd(d8);
        double d15 = Utils.sind(d10);
        double d16 = Utils.cosd(d10);
        double d17 = d11 * d16 - d12 * d15;
        double d18 = d12 * d16 + d11 * d15;
        double d19 = d11 * d14 - d12 * d13;
        double d20 = d12 * d14 + d11 * d13;
        double d21 = 2.0 * d11 * d12;
        double d22 = 2.0 * d12 * d12 - 1.0;
        double d23 = d4 + ((6910.0 - 17.0 * d3) * d11 + 72.0 * d21 - 7.0 * d18 + 6.0 * Utils.sind(d7) + 6.4 * Utils.sind(4.0 * d5 - 8.0 * d9 + 3.0 * d10 + 38.9) - 5.0 * (2.0 * d20 * d20 - 1.0) - 4.0 * d19 + 6.0 * d19 * d20 - 3.0 * d15 - 6.0 * d17 * d18) / 3600.0;
        double d24 = 1.00014 - 0.01675 * d12 - 1.4E-4 * d22;
        return new MajorPlanet(d23, 0.0, d24);
    }

    static MajorPlanet Moon(double d) {
        double d2 = (d - 2415020.0) / 36525.0;
        double d3 = d2 * d2;
        double d4 = Utils.rev360(270.434164 + 481267.8831 * d2) + d3 * (-0.001133 + 1.9E-6 * d2);
        double d5 = Utils.rev360(358.475833 + d2 * (35999.0498 + d2 * (-1.5E-4 - 3.3E-6 * d2)));
        double d6 = Utils.rev360(296.104608 + 477198.8491 * d2) + d3 * (0.009192 + 1.44E-5 * d2);
        double d7 = Utils.rev360(350.737486 + 445267.1142 * d2) + d3 * (-0.001436 + 1.9E-6 * d2);
        double d8 = Utils.rev360(259.183275 + d2 * (-1934.142 + d2 * (0.002078 + 2.2E-6 * d2)));
        double d9 = d4 - d8;
        double d10 = Utils.sind(51.2 + 20.2 * d2);
        double d11 = 0.003964 * Utils.sind(346.56 + d2 * (132.87 - 0.0091731 * d2));
        double d12 = Utils.sind(d8);
        double d13 = Utils.cosd(d8);
        double d14 = Utils.sind(d8 + 275.05 - 2.3 * d2);
        double d15 = Utils.cosd(d8 + 275.05 - 2.3 * d2);
        d4 = d4 + 2.33E-4 * d10 + d11 + 0.001964 * d12;
        d5 -= 0.001778 * d10;
        d6 = d6 + 8.17E-4 * d10 + d11 + 0.002541 * d12;
        d7 = d7 + 0.002011 * d10 + d11 + 0.001964 * d12;
        d9 = d9 - 0.004328 * d14 + d11 - 0.024691 * d12;
        double d16 = 1.0 - d2 * (0.002495 + 7.52E-6 * d2);
        double d17 = d16 * d16;
        double d18 = Utils.sind(d5);
        double d19 = Utils.cosd(d5);
        double d20 = 2.0 * d18 * d19;
        double d21 = 2.0 * d19 * d19 - 1.0;
        double d22 = Utils.sind(d6);
        double d23 = Utils.cosd(d6);
        double d24 = 2.0 * d22 * d23;
        double d25 = 2.0 * d23 * d23 - 1.0;
        double d26 = d24 * d23 + d25 * d22;
        double d27 = d25 * d23 - d24 * d22;
        double d28 = 2.0 * d24 * d25;
        double d29 = d18 * d23 + d19 * d22;
        double d30 = d19 * d23 - d18 * d22;
        double d31 = d18 * d23 - d19 * d22;
        double d32 = d19 * d23 + d18 * d22;
        double d33 = d18 * d25 + d19 * d24;
        double d34 = d19 * d25 - d18 * d24;
        double d35 = d18 * d25 - d19 * d24;
        double d36 = d19 * d25 + d18 * d24;
        double d37 = d22 * d21 - d23 * d20;
        double d38 = d23 * d21 + d22 * d20;
        double d39 = Utils.sind(d7);
        double d40 = Utils.cosd(d7);
        double d41 = 2.0 * d39 * d40;
        double d42 = 2.0 * d40 * d40 - 1.0;
        double d43 = d41 * d40 + d42 * d39;
        double d44 = d42 * d40 - d41 * d39;
        double d45 = 2.0 * d41 * d42;
        double d46 = 2.0 * d42 * d42 - 1.0;
        double d47 = d41 * d23 - d42 * d22;
        double d48 = d42 * d23 + d41 * d22;
        double d49 = d41 * d19 - d42 * d18;
        double d50 = d42 * d19 + d41 * d18;
        double d51 = Utils.sind(d9);
        double d52 = Utils.cosd(d9);
        double d53 = 2.0 * d51 * d52;
        double d54 = 2.0 * d52 * d52 - 1.0;
        double d55 = d53 * d52 + d54 * d51;
        double d56 = d54 * d52 - d53 * d51;
        double d57 = d41 * d52 + d42 * d51;
        double d58 = d42 * d52 - d41 * d51;
        double d59 = d41 * d52 - d42 * d51;
        double d60 = d42 * d52 + d41 * d51;
        double d61 = d41 * d54 + d42 * d53;
        double d62 = d42 * d54 - d41 * d53;
        double d63 = d41 * d54 - d42 * d53;
        double d64 = d42 * d54 + d41 * d53;
        double d65 = d45 * d52 + d46 * d51;
        double d66 = d46 * d52 - d45 * d51;
        double d67 = d45 * d52 - d46 * d51;
        double d68 = d46 * d52 + d45 * d51;
        double d69 = d4 + 6.28875 * d22 + 1.274018 * d47 + 0.658309 * d41 + (0.213616 * d24 - d16 * 0.185596 * d18 - 0.114336 * d53 + 0.058793 * (d41 * d25 - d42 * d24) + d16 * 0.057212 * (d41 * d30 - d42 * d29) + 0.05332 * (d41 * d23 + d42 * d22) + d16 * 0.045874 * (d41 * d19 - d42 * d18) - d16 * 0.041024 * d31 - 0.034718 * d39 - d16 * 0.030465 * d29 + 0.015326 * (d41 * d54 - d42 * d53) - 0.012528 * (d53 * d23 + d54 * d22) - 0.01098 * (d53 * d23 - d54 * d22) + 0.010674 * (d45 * d23 - d46 * d22) + 0.010034 * d26 + 0.008548 * (d45 * d25 - d46 * d24) - d16 * 0.00791 * (d31 * d42 + d32 * d41) - d16 * 0.006783 * (d41 * d19 + d42 * d18) + 0.005162 * (d22 * d40 - d23 * d39) + d16 * 0.005 * (d18 * d40 + d19 * d39) + d16 * 0.004049 * (d41 * d32 - d42 * d31) + 0.003996 * (d24 * d42 + d25 * d41) + 0.003862 * d45 + 0.003665 * (d41 * d27 - d42 * d26) + d16 * 0.002695 * (d24 * d19 - d25 * d18) + 0.002602 * (d22 * d62 - d23 * d61) + d16 * 0.002396 * (d49 * d25 - d50 * d24) - 0.002349 * (d22 * d40 + d23 * d39) + d17 * 0.002249 * (d41 * d21 - d42 * d20) - d16 * 0.002125 * (d24 * d19 + d25 * d18) - d17 * 0.002079 * d20 + d17 * 0.002059 * (d47 * d21 - d48 * d20) - 0.001773 * (d22 * d64 + d23 * d63) - 0.001595 * d61 + d16 * 0.00122 * (d45 * d30 - d46 * d29) - 0.00111 * (d24 * d54 + d25 * d53) + 8.92E-4 * (d22 * d44 - d23 * d43) - d16 * 8.11E-4 * (d29 * d42 + d30 * d41) + d16 * 7.61E-4 * (d45 * d34 - d46 * d33) + d17 * 7.17E-4 * d37 + d17 * 7.04E-4 * (d37 * d42 - d38 * d41) + d16 * 6.93E-4 * (d35 * d42 + d36 * d41) + d16 * 5.98E-4 * (d63 * d19 - d64 * d18) + 5.5E-4 * (d22 * d46 + d23 * d45) + 5.38E-4 * d28 + d16 * 5.21E-4 * (d45 * d19 - d46 * d18) + 4.86E-4 * (d24 * d40 - d25 * d39));
        double d70 = 5.128189 * d51 + (0.280606 * (d22 * d52 + d23 * d51) + 0.277693 * (d22 * d52 - d23 * d51) + 0.173238 * d59 + 0.055413 * (d57 * d23 - d58 * d22) + 0.046272 * (d59 * d23 - d60 * d22) + 0.032573 * d57 + 0.017198 * (d24 * d52 + d25 * d51) + 0.009267 * (d59 * d23 + d60 * d22) + 0.008823 * (d24 * d52 - d25 * d51) + d16 * 0.008247 * (d59 * d19 - d60 * d18) + 0.004323 * (d59 * d25 - d60 * d24) + 0.0042 * (d57 * d23 + d58 * d22) - d16 * 0.003372 * (d59 * d19 + d60 * d18) + d16 * 0.002472 * (d57 * d30 - d58 * d29) + d16 * 0.002222 * (d57 * d19 - d58 * d18) + d16 * 0.002072 * (d59 * d30 - d60 * d29) + d16 * 0.001877 * (d51 * d32 - d52 * d31) + 0.001828 * (d67 * d23 - d68 * d22) - d16 * 0.001803 * (d51 * d19 + d52 * d18) - 0.00175 * d55 - d16 * 0.00157 * (d31 * d52 + d32 * d51) - 0.001487 * (d51 * d40 + d52 * d39) - d16 * 0.001481 * (d51 * d30 + d52 * d29) + d16 * 0.001417 * (d51 * d30 - d52 * d29) + d16 * 0.00135 * (d51 * d19 - d52 * d18) + 0.00133 * (d51 * d40 - d52 * d39) + 0.001106 * (d51 * d27 + d52 * d26) + 0.00102 * d67 + 8.33E-4 * (d65 * d23 - d66 * d22) + 7.81E-4 * (d22 * d56 - d23 * d55) + 6.7E-4 * (d65 * d25 - d66 * d24) + 6.06E-4 * (d41 * d56 - d42 * d55) + 5.97E-4 * (d59 * d25 + d60 * d24) + d16 * 4.92E-4 * (d59 * d32 - d60 * d31) + 4.5E-4 * (d24 * d58 - d25 * d57) + 4.39E-4 * (d26 * d52 - d27 * d51) + 4.23E-4 * (d57 * d25 + d58 * d24) + 4.22E-4 * (d59 * d27 - d60 * d26) + d16 * 3.67E-4 * (d57 * d32 + d58 * d31) - d16 * 3.53E-4 * (d57 * d19 + d58 * d18) + 3.31E-4 * (d51 * d46 + d52 * d45) + d16 * 3.17E-4 * (d57 * d32 - d58 * d31) + d17 * 3.06E-4 * (d59 * d21 - d60 * d20) - 2.83E-4 * (d22 * d56 + d23 * d55));
        double d71 = 4.664E-4 * d13;
        double d72 = 7.54E-5 * d15;
        double d73 = 0.950724 + (0.051818 * d23 + 0.009531 * d48 + 0.007843 * d42 + 0.002824 * d25 + 8.57E-4 * (d42 * d23 - d41 * d22) + d16 * 5.33E-4 * (d42 * d19 + d41 * d18) + d16 * 4.01E-4 * (d42 * d30 + d41 * d29) + d16 * 3.2E-4 * d32 - 2.71E-4 * d40 - d16 * 2.64E-4 * d30 - 1.98E-4 * (d54 * d23 + d53 * d22) + 1.73E-4 * d27 + 1.67E-4 * (d46 * d23 + d45 * d22) - d16 * 1.11E-4 * d19 + 1.03E-4 * (d46 * d25 + d45 * d24) - 8.4E-5 * (d25 * d42 + d24 * d41) - d16 * 8.3E-5 * (d42 * d19 - d41 * d18) + 7.9E-5 * (d42 * d25 - d41 * d24) + 7.2E-5 * d46 + d16 * 6.4E-5 * (d42 * d32 + d41 * d31) - d16 * 6.3E-5 * (d42 * d32 - d41 * d31) + d16 * 4.1E-5 * (d19 * d40 - d18 * d39) + d16 * 3.5E-5 * d36 - 3.3E-5 * (d27 * d42 + d26 * d41) - 3.0E-5 * (d23 * d40 - d22 * d39) - 2.9E-5 * (d54 * d42 + d53 * d41) - d16 * 2.9E-5 * (d25 * d19 - d24 * d18) + d17 * 2.6E-5 * (d42 * d21 + d41 * d20) - 2.3E-5 * (d64 * d23 + d63 * d22) + d16 * 1.9E-5 * (d46 * d30 + d45 * d29));
        double d74 = 4.263496512454038E-5 / Utils.sind(d73);
        return new MajorPlanet(d69, d70 *= 1.0 - d71 - d72, d74);
    }

    static MajorPlanet Mercury(double d) {
        double d2 = d - 2451545.0;
        double d3 = d2 / 36525.0 + 1.0;
        double d4 = 360.0 * Utils.frac(0.140023 + 0.00445036173 * d2);
        double d5 = 360.0 * Utils.frac(0.700695 + 0.011367714 * d2);
        double d6 = 360.0 * Utils.frac(0.485541 + 0.01136759566 * d2);
        double d7 = 360.0 * Utils.frac(0.566441 + 0.01136762384 * d2);
        double d8 = Utils.sind(d6);
        double d9 = Utils.cosd(d6);
        double d10 = Utils.sind(d7);
        double d11 = Utils.cosd(d7);
        double d12 = 2.0 * d8 * d9;
        double d13 = 2.0 * d9 * d9 - 1.0;
        double d14 = d12 * d9 + d13 * d8;
        double d15 = d13 * d9 - d12 * d8;
        double d16 = 2.0 * d12 * d13;
        double d17 = 2.0 * d13 * d13 - 1.0;
        double d18 = d16 * d9 + d17 * d8;
        double d19 = d17 * d9 - d16 * d8;
        double d20 = 2.0 * d10 * d11;
        double d21 = 2.0 * d11 * d11 - 1.0;
        double d22 = d20 * d11 + d21 * d10;
        double d23 = d21 * d11 - d20 * d10;
        double d24 = d5 + ((84378.0 + 8.0 * d3) * d8 + 10733.0 * d12 + 1892.0 * d14 - 646.0 * d20 + 381.0 * d16 - 306.0 * (d8 * d21 - d9 * d20) - 274.0 * (d8 * d21 + d9 * d20) - 92.0 * (d12 * d21 + d13 * d20) + 83.0 * d18 - 28.0 * (d14 * d21 + d15 * d20) + 25.0 * (d12 * d21 - d13 * d20) + 19.0 * (2.0 * d14 * d15) - 9.0 * (d16 * d21 + d17 * d20) + 7.0 * Utils.cosd(2.0 * d6 - 5.0 * d4)) / 3600.0;
        double d25 = (24134.0 * d10 + 5180.0 * (d8 * d11 - d9 * d10) + 4910.0 * (d8 * d11 + d9 * d10) + 1124.0 * (d12 * d11 + d13 * d10) + 271.0 * (d14 * d11 + d15 * d10) + 132.0 * (d12 * d11 - d13 * d10) + 67.0 * (d16 * d11 + d17 * d10) + 18.0 * (d14 * d11 - d15 * d10) + 17.0 * (d18 * d11 + d19 * d10) - 10.0 * d22 - 9.0 * (d8 * d23 - d9 * d22)) / 3600.0;
        double d26 = 0.39528 - 0.07834 * d9 - 0.00795 * d13 - 0.00121 * d15 - 2.2E-4 * d17;
        return new MajorPlanet(d24, d25, d26);
    }

    static MajorPlanet Venus(double d) {
        double d2 = d - 2451545.0;
        double d3 = d2 / 36525.0 + 1.0;
        double d4 = 360.0 * Utils.frac(0.993126 + 0.0027377785 * d2);
        double d5 = Utils.sind(d4);
        double d6 = Utils.cosd(d4);
        double d7 = 360.0 * Utils.frac(0.505498 + 0.00445046867 * d2);
        double d8 = 360.0 * Utils.frac(0.140023 + 0.00445036173 * d2);
        double d9 = 360.0 * Utils.frac(0.292498 + 0.00445040017 * d2);
        double d10 = Utils.sind(d8);
        double d11 = Utils.cosd(d8);
        double d12 = Utils.sind(d9);
        double d13 = Utils.cosd(d9);
        double d14 = 2.0 * d10 * d11;
        double d15 = 2.0 * d11 * d11 - 1.0;
        double d16 = d14 * d11 + d15 * d10;
        double d17 = d15 * d11 - d14 * d10;
        double d18 = 2.0 * d5 * d6;
        double d19 = 2.0 * d6 * d6 - 1.0;
        double d20 = d18 * d6 + d19 * d5;
        double d21 = d19 * d6 - d18 * d5;
        double d22 = d7 + ((2814.0 - 20.0 * d3) * d10 - 181.0 * (2.0 * d12 * d13) + 12.0 * d14 - 10.0 * (d19 * d15 + d18 * d14) + 7.0 * (d21 * d17 + d20 * d16)) / 3600.0;
        double d23 = (12215.0 * d12 + 83.0 * (d10 * d13 + d11 * d12) + 83.0 * (d10 * d13 - d11 * d12)) / 3600.0;
        double d24 = 0.72335 - 0.00493 * d11;
        return new MajorPlanet(d22, d23, d24);
    }

    static MajorPlanet Mars(double d) {
        double d2 = d - 2451545.0;
        double d3 = d2 / 36525.0 + 1.0;
        double d4 = 360.0 * Utils.frac(0.993126 + 0.0027377785 * d2);
        double d5 = Utils.sind(d4);
        double d6 = Utils.cosd(d4);
        double d7 = 360.0 * Utils.frac(0.140023 + 0.00445036173 * d2);
        double d8 = 360.0 * Utils.frac(0.056531 + 2.3080893E-4 * d2);
        double d9 = 360.0 * Utils.frac(0.987353 + 0.00145575328 * d2);
        double d10 = 360.0 * Utils.frac(0.053856 + 0.00145561327 * d2);
        double d11 = 360.0 * Utils.frac(0.849694 + 0.00145569465 * d2);
        double d12 = Utils.sind(d10);
        double d13 = Utils.cosd(d10);
        double d14 = Utils.sind(d11);
        double d15 = Utils.cosd(d11);
        double d16 = Utils.sind(d7);
        double d17 = Utils.cosd(d7);
        double d18 = Utils.sind(d8);
        double d19 = Utils.cosd(d8);
        double d20 = 2.0 * d5 * d6;
        double d21 = 2.0 * d6 * d6 - 1.0;
        double d22 = 2.0 * d12 * d13;
        double d23 = 2.0 * d13 * d13 - 1.0;
        double d24 = d22 * d13 + d23 * d12;
        double d25 = d23 * d13 - d22 * d12;
        double d26 = 2.0 * d22 * d23;
        double d27 = 2.0 * d23 * d23 - 1.0;
        double d28 = 2.0 * d14 * d15;
        double d29 = 2.0 * d15 * d15 - 1.0;
        double d30 = 2.0 * d18 * d19;
        double d31 = 2.0 * d19 * d19 - 1.0;
        double d32 = d9 + ((38451.0 + 37.0 * d3) * d12 + (2238.0 + 4.0 * d3) * d22 + 181.0 * d24 - 52.0 * d28 - 22.0 * (d13 * d31 + d12 * d30) - 19.0 * (d12 * d19 - d13 * d18) + 17.0 * (d13 * d19 + d12 * d18) + 17.0 * d26 - 16.0 * (d23 * d31 + d22 * d30) + 13.0 * (d6 * d23 + d5 * d22) - 10.0 * (d12 * d29 - d13 * d28) - 10.0 * (d12 * d29 + d13 * d28) + 7.0 * (d6 * d13 + d5 * d12) - 7.0 * (d21 * d25 + d20 * d24) - 5.0 * (d16 * d25 - d17 * d24) - 5.0 * (d5 * d13 - d6 * d12) - 5.0 * (d5 * d23 - d6 * d22) - 4.0 * (d21 * d27 + d20 * d26) + 4.0 * d19 + 3.0 * (d17 * d25 + d16 * d24) + 3.0 * (d22 * d31 - d23 * d30)) / 3600.0;
        double d33 = (6603.0 * d14 + 622.0 * (d12 * d15 - d13 * d14) + 615.0 * (d12 * d15 + d13 * d14) + 64.0 * (d22 * d15 + d23 * d14)) / 3600.0;
        double d34 = 1.53031 - 0.1417 * d13 - 0.0066 * d23 - 4.7E-4 * d25;
        return new MajorPlanet(d32, d33, d34);
    }

    static MajorPlanet Jupiter(double d) {
        double d2 = (d - 2415020.0) / 36525.0;
        double d3 = d2 * 0.2 + 0.1;
        double d4 = Utils.rev180(238.049257 + 3036.301986 * d2) + d2 * d2 * (3.347E-4 - 1.65E-6 * d2);
        double d5 = 5.202561;
        double d6 = 0.04833475 + d2 * (1.6418E-4 + d2 * (-4.676E-7 - 1.7E-9 * d2));
        double d7 = 1.308736 + d2 * (-0.0056961 + 3.9E-6 * d2);
        double d8 = 273.277558 + d2 * (0.5994317 + d2 * (7.0405E-4 + 5.08E-6 * d2));
        double d9 = 99.443414 + d2 * (1.01053 + (3.5222E-4 - 8.51E-6 * d2));
        double d10 = Utils.rev180(d4 - d8 - d9);
        double d11 = 265.9165 + 1222.1139 * d2;
        double d12 = 134.6314 + 40.7573 * d2;
        double d13 = 330.00373 + 22.5319 * d2;
        double d14 = 28.44095 - 1812.7922 * d2;
        double d15 = Utils.sind(d11);
        double d16 = Utils.cosd(d11);
        double d17 = 2.0 * d15 * d16;
        double d18 = 2.0 * d16 * d16 - 1.0;
        double d19 = Utils.sind(d12);
        double d20 = Utils.cosd(d12);
        double d21 = 2.0 * d19 * d20;
        double d22 = Utils.sind(d14);
        double d23 = Utils.cosd(d14);
        double d24 = 2.0 * d22 * d23;
        double d25 = 2.0 * d23 * d23 - 1.0;
        double d26 = d22 * d25 + d23 * d24;
        double d27 = d23 * d25 - d22 * d24;
        double d28 = 2.0 * d24 * d25;
        double d29 = 2.0 * d25 * d25 - 1.0;
        double d30 = d23 * d29 - d22 * d28;
        double d31 = (0.331364 - d3 * (0.010281 + 0.004692 * d3)) * d19 + (0.003228 + d3 * (-0.064436 + 0.002075 * d3)) * d20 - (0.003083 + d3 * (2.75E-4 - 4.89E-4 * d3)) * d21 + 0.002472 * Utils.sind(d13) + 0.013619 * d22 + 0.018472 * d24 + 0.006717 * d26 + 0.002775 * d28 + (0.007275 - 0.001253 * d3) * d22 * d15 + 0.006417 * d24 * d15 + 0.002439 * d26 * d15 - (0.033839 + 0.001125 * d3) * d23 * d15 - 0.003767 * d25 * d15 - (0.035681 + 0.001208 * d3) * d22 * d16 - 0.004261 * d24 * d16 + 0.002178 * d16 + (-0.006333 + 0.001161 * d3) * d23 * d16 - 0.006675 * d25 * d16 - 0.002664 * d27 * d16 - 0.002572 * d22 * d17 - 0.003567 * d24 * d17 + 0.002094 * d23 * d18 + 0.003342 * d25 * d18;
        double d32 = (3.606E-4 + d3 * (1.3E-5 - 4.3E-6 * d3)) * d19 + (1.289E-4 - 5.8E-5 * d3) * d20 - 6.764E-4 * d22 * d15 - 1.11E-4 * d24 * d15 - 2.24E-5 * d26 * d15 - 2.04E-5 * d15 + (1.284E-4 + 1.16E-5 * d3) * d23 * d15 + 1.88E-5 * d25 * d15 + (1.46E-4 + 1.3E-5 * d3) * d22 * d16 + 2.24E-5 * d24 * d16 - 8.17E-5 * d16 + 6.074E-4 * d23 * d16 + 9.92E-5 * d25 * d16 + 5.08E-5 * d27 * d16 + 2.3E-5 * d29 * d16 + 1.08E-5 * d30 * d16 - (9.56E-5 + 7.3E-6 * d3) * d22 * d17 + 4.48E-5 * d24 * d17 + 1.37E-5 * d26 * d17 + (-9.97E-5 + 1.08E-5 * d3) * d23 * d17 + 4.8E-5 * d25 * d17 + 1.48E-5 * d27 * d17 + (-9.56E-5 + 9.9E-6 * d3) * d22 * d18 + 4.9E-5 * d24 * d18 + 1.58E-5 * d26 * d18 + 1.79E-5 * d18 + (1.024E-4 + 7.5E-6 * d3) * d23 * d18 - 4.37E-5 * d25 * d18 - 1.32E-5 * d27 * d18;
        double d33 = ((0.007192 - 0.003147 * d3) * d19 + (-0.020428 + d3 * (-6.75E-4 + 1.97E-4 * d3)) * d20 + (0.007269 + 6.72E-4 * d3) * d22 * d15 - 0.004344 * d15 + 0.034036 * d23 * d15 + 0.005614 * d25 * d15 + 0.002964 * d27 * d15 + 0.037761 * d22 * d16 + 0.006158 * d24 * d16 - 0.006603 * d23 * d16 - 0.005356 * d22 * d17 + 0.002722 * d24 * d17 + 0.004483 * d23 * d17 - 0.002642 * d25 * d17 + 0.004403 * d22 * d18 - 0.002536 * d24 * d18 + 0.005547 * d23 * d18 - 0.002689 * d25 * d18) / d6;
        double d34 = d31 - d33;
        double d35 = -2.63E-4 * d20 + 2.05E-4 * d23 + 6.93E-4 * d25 + 3.12E-4 * d27 + 1.47E-4 * d29 + 2.99E-4 * d22 * d15 + 1.81E-4 * d25 * d15 + 2.04E-4 * d24 * d16 + 1.11E-4 * d26 * d16 - 3.37E-4 * d23 * d16 - 1.11E-4 * d25 * d16;
        Pol2 pol2 = Utils.vr(d10 += d34, d6 += d32, d5 += d35);
        Rect3 rect3 = Utils.helpos(pol2.v, pol2.r, d8 += d33, d7, d9);
        double d36 = Utils.atan2d(rect3.y, rect3.x);
        double d37 = Utils.atan2d(rect3.z, Utils.sqsum(rect3.x, rect3.y));
        double d38 = Utils.sqsum(rect3.x, rect3.y, rect3.z);
        return new MajorPlanet(d36, d37, d38);
    }

    static MajorPlanet Saturn(double d) {
        double d2 = (d - 2415020.0) / 36525.0;
        double d3 = d2 * 0.2 + 0.1;
        double d4 = Utils.rev180(266.564377 + 1223.509884 * d2) + d2 * d2 * (3.245E-4 - 5.8E-6 * d2);
        double d5 = 9.554747;
        double d6 = 0.05589232 + d2 * (-3.455E-4 + d2 * (-7.28E-7 - 7.4E-10 * d2));
        double d7 = 2.492519 + d2 * (-0.0039189 + (-1.549E-5 + 4.0E-8 * d2));
        double d8 = 338.3078 + d2 * (1.0852207 + d2 * (9.7854E-4 + 9.92E-6 * d2));
        double d9 = 112.790414 + d2 * (0.8731951 + (-1.5218E-4 - 5.31E-6 * d2));
        double d10 = Utils.rev180(d4 - d8 - d9);
        double d11 = 265.9165 + 1222.1139 * d2;
        double d12 = 134.6314 + 40.7573 * d2;
        double d13 = 330.00373 + 22.5319 * d2;
        double d14 = 28.44095 - 1812.7922 * d2;
        double d15 = 337.60071 - 793.6462 * d2;
        double d16 = Utils.sind(d11);
        double d17 = Utils.cosd(d11);
        double d18 = 2.0 * d16 * d17;
        double d19 = 2.0 * d17 * d17 - 1.0;
        double d20 = d16 * d19 + d17 * d18;
        double d21 = d17 * d19 - d16 * d18;
        double d22 = 2.0 * d18 * d19;
        double d23 = 2.0 * d19 * d19 - 1.0;
        double d24 = Utils.sind(d12);
        double d25 = Utils.cosd(d12);
        double d26 = 2.0 * d24 * d25;
        double d27 = 2.0 * d25 * d25 - 1.0;
        double d28 = Utils.sind(d14);
        double d29 = Utils.cosd(d14);
        double d30 = 2.0 * d28 * d29;
        double d31 = 2.0 * d29 * d29 - 1.0;
        double d32 = d28 * d31 + d29 * d30;
        double d33 = d29 * d31 - d28 * d30;
        double d34 = 2.0 * d30 * d31;
        double d35 = 2.0 * d31 * d31 - 1.0;
        double d36 = d28 * d35 + d29 * d34;
        double d37 = d29 * d35 - d28 * d34;
        double d38 = Utils.sind(d15);
        double d39 = Utils.cosd(d15);
        double d40 = 2.0 * d38 * d39;
        double d41 = 2.0 * d39 * d39 - 1.0;
        double d42 = d38 * d41 + d39 * d40;
        double d43 = d39 * d41 - d38 * d40;
        double d44 = (-0.814181 + d3 * (0.01815 + 0.016714 * d3)) * d24 + (-0.010497 + d3 * (0.160906 - 0.0041 * d3)) * d25 + 0.007581 * d26 - 0.007986 * Utils.sind(d13) - 0.148811 * d28 - 0.040786 * d30 - 0.015208 * d32 - 0.006339 * d34 - 0.006244 * d16 + (0.008931 + 0.002728 * d3) * d28 * d16 - 0.0165 * d30 * d16 - 0.005775 * d32 * d16 + (0.081344 + 0.003206 * d3) * d29 * d16 + 0.015019 * d31 * d16 + (0.085581 + 0.002494 * d3) * d28 * d17 + (0.025328 - 0.003117 * d3) * d29 * d17 + 0.014394 * d31 * d17 + 0.006319 * d33 * d17 + 0.006369 * d28 * d18 + 0.009156 * d30 * d18 + 0.007525 * d42 * d18 - 0.005236 * d29 * d19 - 0.007736 * d31 * d19 - 0.007528 * d43 * d19;
        double d45 = (-7.927E-4 + d3 * (2.548E-4 + 9.1E-6 * d3)) * d24 + (0.0013381 + d3 * (1.226E-4 - 2.53E-5 * d3)) * d25 + (2.48E-5 - 1.21E-5 * d3) * d26 - (3.05E-5 + 9.1E-6 * d3) * d27 + 4.12E-5 * d30 + 0.0012415 * d16 + (3.9E-5 - 6.17E-5 * d3) * d28 * d16 + (1.65E-5 - 2.04E-5 * d3) * d30 * d16 + 0.0026599 * d29 * d16 - 4.687E-4 * d31 * d16 - 1.87E-4 * d33 * d16 - 8.21E-5 * d35 * d16 - 3.77E-5 * d37 * d16 + 4.97E-5 * d41 * d16 + (1.63E-5 - 6.11E-5 * d3) * d17 - 0.0012696 * d28 * d17 - 4.2E-4 * d30 * d17 - 1.503E-4 * d32 * d17 - 6.19E-5 * d34 * d17 - 2.68E-5 * d36 * d17 - (2.82E-5 + 1.306E-4 * d3) * d29 * d17 + (-8.6E-6 + 2.3E-5 * d3) * d31 * d17 + 4.61E-5 * d40 * d17 - 3.5E-5 * d18 + (2.211E-4 - 2.86E-5 * d3) * d28 * d18 - 2.208E-4 * d30 * d18 - 5.68E-5 * d32 * d18 - 3.46E-5 * d34 * d18 - (2.78E-4 + 2.22E-5 * d3) * d29 * d18 + (2.022E-4 + 2.63E-5 * d3) * d31 * d18 + 2.48E-5 * d33 * d18 + 2.42E-5 * d42 * d18 + 4.67E-5 * d43 * d18 - 4.9E-5 * d19 - (2.842E-4 + 2.79E-5 * d3) * d28 * d19 + (1.28E-5 + 2.26E-5 * d3) * d30 * d19 + 2.24E-5 * d32 * d19 + (-1.594E-4 + 2.82E-5 * d3) * d29 * d19 + (2.162E-4 - 2.07E-5 * d3) * d31 * d19 + 5.61E-5 * d33 * d19 + 3.43E-5 * d35 * d19 + 4.69E-5 * d42 * d19 - 2.42E-5 * d43 * d19 - 2.05E-5 * d28 * d20 + 2.62E-5 * d32 * d20 + 2.08E-5 * d29 * d21 - 2.71E-5 * d33 * d21 - 3.82E-5 * d33 * d22 - 3.76E-5 * d32 * d23;
        double d46 = ((0.077108 + d3 * (0.007186 - 0.001533 * d3)) * d24 + (0.045803 - d3 * (0.014766 + 5.36E-4 * d3)) * d25 - 0.007075 * d28 - 0.075825 * d28 * d16 - 0.024839 * d30 * d16 - 0.008631 * d32 * d16 - 0.072586 * d17 - 0.150383 * d29 * d17 + 0.026897 * d31 * d17 + 0.010053 * d33 * d17 - (0.013597 + 0.001719 * d3) * d28 * d18 + (-0.007742 + 0.001517 * d3) * d29 * d18 + (0.013586 - 0.001375 * d3) * d31 * d18 + (-0.013667 + 0.001239 * d3) * d28 * d19 + 0.011981 * d30 * d19 + (0.014861 + 0.001136 * d3) * d29 * d19 - (0.013064 + 0.001628 * d3) * d31 * d19) / d6;
        double d47 = d44 - d46;
        double d48 = 5.72E-4 * d3 * d24 + 0.002933 * d25 + 0.033629 * d29 - 0.003081 * d31 - 0.001423 * d33 - 6.71E-4 * d35 - 3.2E-4 * d37 + 0.001098 * d16 - 0.002812 * d28 * d16 + 6.88E-4 * d30 * d16 - 3.93E-4 * d32 * d16 - 2.28E-4 * d34 * d16 + 0.002138 * d29 * d16 - 9.99E-4 * d31 * d16 - 6.42E-4 * d33 * d16 - 3.25E-4 * d35 * d16 - 8.9E-4 * d17 + 0.002206 * d28 * d17 - 0.00159 * d30 * d17 - 6.47E-4 * d32 * d17 - 3.44E-4 * d34 * d17 + 0.002885 * d29 * d17 + (0.002172 + 1.02E-4 * d3) * d31 * d17 + 2.96E-4 * d33 * d17 - 2.67E-4 * d30 * d18 - 7.78E-4 * d29 * d18 + 4.95E-4 * d31 * d18 + 2.5E-4 * d33 * d18 - 8.56E-4 * d28 * d19 + 4.41E-4 * d30 * d19 + 2.96E-4 * d31 * d19 + 2.11E-4 * d33 * d19 - 4.27E-4 * d28 * d20 + 3.98E-4 * d32 * d20 + 3.44E-4 * d29 * d21 - 4.27E-4 * d33 * d21;
        double d49 = 7.47E-4 * d29 * d16 + 0.001069 * d29 * d17 + 0.002108 * d30 * d18 + 0.001261 * d31 * d18 + 0.001236 * d30 * d19 - 0.002075 * d31 * d19;
        Pol2 pol2 = Utils.vr(d10 += d47, d6 += d45, d5 += d48);
        Rect3 rect3 = Utils.helpos(pol2.v, pol2.r, d8 += d46, d7, d9);
        double d50 = Utils.atan2d(rect3.y, rect3.x);
        double d51 = Utils.atan2d(rect3.z, Utils.sqsum(rect3.x, rect3.y)) + d49;
        double d52 = Utils.sqsum(rect3.x, rect3.y, rect3.z);
        return new MajorPlanet(d50, d51, d52);
    }

    static MajorPlanet Uranus(double d) {
        double d2 = (d - 2415020.0) / 36525.0;
        double d3 = d2 * 0.2 + 0.1;
        double d4 = 237.47555 + 3034.9061 * d2;
        double d5 = 265.9165 + 1222.1139 * d2;
        double d6 = 243.51721 + 428.4677 * d2;
        double d7 = 83.76922 + 218.4901 * d2;
        double d8 = 2.0 * d7 - d6;
        double d9 = d7 - d6;
        double d10 = Utils.sind(d8);
        double d11 = Utils.cosd(d8);
        double d12 = 2.0 * d10 * d11;
        double d13 = 2.0 * d11 * d11 - 1.0;
        double d14 = Utils.sind(d9);
        double d15 = Utils.cosd(d9);
        double d16 = 2.0 * d14 * d15;
        double d17 = 2.0 * d15 * d15 - 1.0;
        double d18 = Utils.rev180(244.19747 + 429.863546 * d2) + d2 * d2 * (3.16E-4 - 6.0E-7 * d2);
        double d19 = 19.21814;
        double d20 = 0.0463444 + d2 * (-2.658E-5 + 7.7E-8 * d2);
        double d21 = 0.772464 + d2 * (6.253E-4 + 3.95E-5 * d2);
        double d22 = 98.071581 + d2 * (0.985765 + d2 * (-0.0010745 - 6.1E-7 * d2));
        double d23 = 73.477111 + d2 * (0.4986678 + 0.0013117 * d2);
        double d24 = Utils.rev180(d18 - d22 - d23);
        double d25 = 330.00373 + 22.5319 * d2;
        double d26 = d6 - d4;
        double d27 = d6 - d5;
        double d28 = Utils.sind(d26);
        double d29 = Utils.cosd(d26);
        double d30 = Utils.sind(d27);
        double d31 = Utils.cosd(d27);
        double d32 = d14 * d17 + d15 * d16;
        double d33 = d15 * d17 - d14 * d16;
        double d34 = 2.0 * d17 * d17 - 1.0;
        double d35 = 4.0 * d30 * d31 * (1.0 - 2.0 * d30 * d30);
        double d36 = Utils.sind(d6);
        double d37 = Utils.cosd(d6);
        double d38 = 2.0 * d36 * d37;
        double d39 = 2.0 * d37 * d37 - 1.0;
        double d40 = (0.864319 - 0.001583 * d3) * d10 + (0.082222 - 0.006833 * d3) * d11 + 0.036017 * d12 - 0.003019 * d13 + 0.008122 * Utils.sind(d25);
        double d41 = (-3.349E-4 + 1.63E-5 * d3) * d10 + 0.0020981 * d11 + 1.311E-4 * d13;
        double d42 = (0.120303 * d10 + (0.019472 - 9.47E-4 * d3) * d11 + 0.006197 * d12) / d20;
        double d43 = d40 - d42;
        double d44 = -0.003825 * d11;
        double d45 = (0.010122 - 9.88E-4 * d3) * (d36 * d31 + d37 * d30) + (-0.038581 + d3 * (0.002031 - 0.00191 * d3)) * (d37 * d31 - d36 * d30) + (0.034964 + d3 * (-0.001038 + 8.68E-4 * d3)) * (d39 * d31 - d38 * d30) + 0.005594 * (d36 * d33 + d37 * d32) - 0.014808 * d28 - 0.005794 * d30 + 0.002347 * d31 + 0.009872 * d14 + 0.008803 * d16 - 0.004308 * d32;
        double d46 = (4.58E-4 * d30 - 6.42E-4 * d31 - 5.17E-4 * d34) * d36 - (3.47E-4 * d30 + 8.53E-4 * d31 + 5.17E-4 * d35) * d37 + 4.03E-4 * (d17 * d38 + d16 * d39);
        double d47 = -0.025948 + 0.004985 * d29 - 0.00123 * d37 + 0.003354 * d31 + (0.005795 * d37 - 0.001165 * d36 + 0.001388 * d39) * d30 + (0.001351 * d37 + 0.005702 * d36 + 0.001388 * d38) * d31 + 9.04E-4 * d17 + 8.94E-4 * (d15 - d33);
        Pol2 pol2 = Utils.vr(d24 += d43, d20 += d41, d19 += d44);
        Rect3 rect3 = Utils.helpos(pol2.v, pol2.r, d22 += d42, d21, d23);
        double d48 = Utils.atan2d(rect3.y, rect3.x) + d45;
        double d49 = Utils.atan2d(rect3.z, Math.sqrt(rect3.x * rect3.x + rect3.y * rect3.y)) + d46;
        double d50 = Math.sqrt(rect3.x * rect3.x + rect3.y * rect3.y + rect3.z * rect3.z) + d47;
        return new MajorPlanet(d48, d49, d50);
    }

    static MajorPlanet Neptune(double d) {
        double d2 = (d - 2415020.0) / 36525.0;
        double d3 = d2 * 0.2 + 0.1;
        double d4 = 237.47555 + 3034.9061 * d2;
        double d5 = 265.9165 + 1222.1139 * d2;
        double d6 = 243.51721 + 428.4677 * d2;
        double d7 = 83.76922 + 218.4901 * d2;
        double d8 = 2.0 * d7 - d6;
        double d9 = d7 - d6;
        double d10 = Utils.sind(d8);
        double d11 = Utils.cosd(d8);
        double d12 = 2.0 * d10 * d11;
        double d13 = 2.0 * d11 * d11 - 1.0;
        double d14 = Utils.sind(d9);
        double d15 = Utils.cosd(d9);
        double d16 = 2.0 * d14 * d15;
        double d17 = 2.0 * d15 * d15 - 1.0;
        double d18 = Utils.rev180(84.457994 + 219.885914 * d2) + d2 * d2 * (3.205E-4 - 6.0E-7 * d2);
        double d19 = 30.10957;
        double d20 = 0.00899704 + d2 * (6.33E-6 - 2.0E-9 * d2);
        double d21 = 1.779242 + d2 * (-0.0095436 - 9.1E-6 * d2);
        double d22 = 276.045975 + d2 * (0.3256394 + d2 * (1.4095E-4 + 4.113E-6 * d2));
        double d23 = 130.681389 + d2 * (1.098935 + d2 * (2.4987E-4 - 4.718E-6 * d2));
        double d24 = Utils.rev180(d18 - d22 - d23);
        double d25 = d7 - d4;
        double d26 = d7 - d5;
        double d27 = Utils.sind(d25);
        double d28 = Utils.cosd(d25);
        double d29 = Utils.sind(d26);
        double d30 = Utils.cosd(d26);
        double d31 = Utils.sind(d7);
        double d32 = Utils.cosd(d7);
        double d33 = (-0.589833 + 0.001089 * d3) * d10 + (-0.056094 + 0.004658 * d3) * d11 - 0.024286 * d12;
        double d34 = 4.389E-4 * d10 + 4.262E-4 * d11 + 1.129E-4 * d12 + 1.089E-4 * d13;
        double d35 = (0.024039 * d10 - 0.025303 * d11 + 0.006206 * d12 - 0.005992 * d13) / d20;
        double d36 = d33 - d35;
        double d37 = -8.17E-4 * d10 + 0.008189 * d11 + 7.81E-4 * d13;
        double d38 = -0.009556 * d27 - 0.005178 * d29 + 0.002572 * d16 - 0.002972 * d17 * d31 - 0.002833 * d16 * d32;
        double d39 = 3.36E-4 * d17 * d31 + 3.64E-4 * d16 * d32;
        double d40 = -0.040596 + 0.004992 * d28 + 0.002744 * d30 + 0.002044 * d15 + 0.001051 * d17;
        Pol2 pol2 = Utils.vr(d24 += d36, d20 += d34, d19 += d37);
        Rect3 rect3 = Utils.helpos(pol2.v, pol2.r, d22 += d35, d21, d23);
        double d41 = Utils.atan2d(rect3.y, rect3.x) + d38;
        double d42 = Utils.atan2d(rect3.z, Math.sqrt(rect3.x * rect3.x + rect3.y * rect3.y)) + d39;
        double d43 = Utils.sqsum(rect3.x, rect3.y, rect3.z) + d40;
        return new MajorPlanet(d41, d42, d43);
    }

    private static MajorPlanet R2P(Rect3 rect3) {
        double d = Utils.atan2d(rect3.y, rect3.x);
        double d2 = Utils.atan2d(rect3.z, Utils.sqsum(rect3.x, rect3.y));
        double d3 = Utils.sqsum(rect3.x, rect3.y, rect3.z);
        return new MajorPlanet(d, d2, d3);
    }

    static MajorPlanet geocentric(MajorPlanet majorPlanet, MajorPlanet majorPlanet2) {
        Rect3 rect3 = Utils.P2R(majorPlanet);
        Rect3 rect32 = Utils.P2R(majorPlanet2);
        Rect3 rect33 = Utils.R3sum(rect3, rect32);
        return MajorPlanet.R2P(rect33);
    }

    static MajorPlanet geocentric(MajorPlanet majorPlanet, double d) {
        return MajorPlanet.geocentric(majorPlanet, MajorPlanet.Sun(d));
    }
}

