/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.ephemeris;

import com.lavadip.skeye.astro.ephemeris.Ephemeris;
import com.lavadip.skeye.astro.ephemeris.LoLa;
import com.lavadip.skeye.astro.ephemeris.MajorPlanet;
import com.lavadip.skeye.astro.ephemeris.Utils;
import java.util.Date;

public final class EphemerisImplementation
implements Ephemeris {
    private static final double JD_J2000 = 2451545.0;
    private static final double EQUINOX_OF_DAY = -1111.0;
    private static double JDequinox = 2451545.0;

    @Override
    public void setJequinox(double d) {
        JDequinox = 2451545.0 + (d - 2000.0) * 365.25;
    }

    @Override
    public void setEquinoxOfDay() {
        JDequinox = -1111.0;
    }

    private Ephemeris.PlanetData precessData(Ephemeris.PlanetData planetData, double d) {
        if (JDequinox != -1111.0) {
            LoLa loLa = new LoLa(planetData.RA, planetData.Dec);
            LoLa loLa2 = Utils.prec(d, loLa, JDequinox);
            return new Ephemeris.PlanetData(loLa2.lo, loLa2.la, planetData.r);
        }
        return planetData;
    }

    private Ephemeris.PlanetData getPlanetPositionEquinoxOfDay(double d, Ephemeris.Planet planet) {
        MajorPlanet majorPlanet;
        switch (planet) {
            case SUN: {
                majorPlanet = MajorPlanet.Sun(d);
                break;
            }
            case MOON: {
                majorPlanet = MajorPlanet.Moon(d);
                break;
            }
            case MERCURY: {
                majorPlanet = MajorPlanet.geocentric(MajorPlanet.Mercury(d), d);
                break;
            }
            case VENUS: {
                majorPlanet = MajorPlanet.geocentric(MajorPlanet.Venus(d), d);
                break;
            }
            case MARS: {
                majorPlanet = MajorPlanet.geocentric(MajorPlanet.Mars(d), d);
                break;
            }
            case JUPITER: {
                majorPlanet = MajorPlanet.geocentric(MajorPlanet.Jupiter(d), d);
                break;
            }
            case SATURN: {
                majorPlanet = MajorPlanet.geocentric(MajorPlanet.Saturn(d), d);
                break;
            }
            case URANUS: {
                majorPlanet = MajorPlanet.geocentric(MajorPlanet.Uranus(d), d);
                break;
            }
            case NEPTUNE: {
                majorPlanet = MajorPlanet.geocentric(MajorPlanet.Neptune(d), d);
                break;
            }
            default: {
                return null;
            }
        }
        double d2 = Utils.oblecl(d);
        return Utils.eclequ(majorPlanet, d2);
    }

    @Override
    public Ephemeris.PlanetData getPlanetPosition(Date date, Ephemeris.Planet planet) {
        double d = Utils.JED(date);
        Ephemeris.PlanetData planetData = this.getPlanetPositionEquinoxOfDay(d, planet);
        return this.precessData(planetData, d);
    }

    @Override
    public Ephemeris.PlanetData getPlanetPosition(Date date, Ephemeris.Planet planet, double d, double d2) {
        double d3 = Utils.JED(date);
        Ephemeris.PlanetData planetData = this.getPlanetPositionEquinoxOfDay(d3, planet);
        double d4 = Utils.JD(date);
        planetData = Utils.topocentric(planetData, d4, d, d2);
        return this.precessData(planetData, d3);
    }

    private Ephemeris.PlanetData[] getPlanetPositionsEquinoxOfDay(double d) {
        Ephemeris.PlanetData[] planetDataArray = new Ephemeris.PlanetData[9];
        MajorPlanet majorPlanet = MajorPlanet.Sun(d);
        MajorPlanet[] majorPlanetArray = new MajorPlanet[]{majorPlanet, MajorPlanet.Moon(d), MajorPlanet.geocentric(MajorPlanet.Mercury(d), majorPlanet), MajorPlanet.geocentric(MajorPlanet.Venus(d), majorPlanet), MajorPlanet.geocentric(MajorPlanet.Mars(d), majorPlanet), MajorPlanet.geocentric(MajorPlanet.Jupiter(d), majorPlanet), MajorPlanet.geocentric(MajorPlanet.Saturn(d), majorPlanet), MajorPlanet.geocentric(MajorPlanet.Uranus(d), majorPlanet), MajorPlanet.geocentric(MajorPlanet.Neptune(d), majorPlanet)};
        double d2 = Utils.oblecl(d);
        for (int i = 0; i < 9; ++i) {
            planetDataArray[i] = Utils.eclequ(majorPlanetArray[i], d2);
        }
        return planetDataArray;
    }

    @Override
    public Ephemeris.PlanetData[] getPlanetPositions(Date date) {
        double d = Utils.JED(date);
        Ephemeris.PlanetData[] planetDataArray = this.getPlanetPositionsEquinoxOfDay(d);
        for (int i = 0; i < 9; ++i) {
            planetDataArray[i] = this.precessData(planetDataArray[i], d);
        }
        return planetDataArray;
    }

    @Override
    public Ephemeris.PlanetData[] getPlanetPositions(Date date, double d, double d2) {
        int n;
        double d3 = Utils.JED(date);
        Ephemeris.PlanetData[] planetDataArray = this.getPlanetPositionsEquinoxOfDay(d3);
        double d4 = Utils.JD(date);
        for (n = 0; n < 5; ++n) {
            planetDataArray[n] = Utils.topocentric(planetDataArray[n], d4, d, d2);
        }
        for (n = 0; n < 9; ++n) {
            planetDataArray[n] = this.precessData(planetDataArray[n], d3);
        }
        return planetDataArray;
    }

    @Override
    public Ephemeris.PlanetData[] getSunMoonPositions(Date date, double d, double d2) {
        int n;
        double d3 = Utils.JED(date);
        Ephemeris.PlanetData[] planetDataArray = this.getSunMoonPositionsEquinoxOfDay(d3);
        double d4 = Utils.JD(date);
        for (n = 0; n < 2; ++n) {
            planetDataArray[n] = Utils.topocentric(planetDataArray[n], d4, d, d2);
        }
        for (n = 0; n < 2; ++n) {
            planetDataArray[n] = this.precessData(planetDataArray[n], d3);
        }
        return planetDataArray;
    }

    private Ephemeris.PlanetData[] getSunMoonPositionsEquinoxOfDay(double d) {
        Ephemeris.PlanetData[] planetDataArray = new Ephemeris.PlanetData[2];
        MajorPlanet majorPlanet = MajorPlanet.Sun(d);
        MajorPlanet[] majorPlanetArray = new MajorPlanet[]{majorPlanet, MajorPlanet.Moon(d)};
        double d2 = Utils.oblecl(d);
        for (int i = 0; i < 2; ++i) {
            planetDataArray[i] = Utils.eclequ(majorPlanetArray[i], d2);
        }
        return planetDataArray;
    }
}

