/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro.ephemeris;

import com.lavadip.skeye.astro.ephemeris.Rect3;
import com.lavadip.skeye.astro.ephemeris.Utils;
import java.util.Date;

public interface Ephemeris {
    public PlanetData getPlanetPosition(Date var1, Planet var2);

    public PlanetData getPlanetPosition(Date var1, Planet var2, double var3, double var5);

    public PlanetData[] getPlanetPositions(Date var1);

    public PlanetData[] getPlanetPositions(Date var1, double var2, double var4);

    public PlanetData[] getSunMoonPositions(Date var1, double var2, double var4);

    public void setJequinox(double var1);

    public void setEquinoxOfDay();

    public static enum Planet {
        SUN,
        MOON,
        MERCURY,
        VENUS,
        MARS,
        JUPITER,
        SATURN,
        URANUS,
        NEPTUNE;

    }

    public static class PlanetData {
        public final double RA;
        public final double Dec;
        public final double r;

        public PlanetData(double d, double d2, double d3) {
            while (d < 0.0) {
                d += 360.0;
            }
            this.RA = d;
            this.Dec = d2;
            this.r = d3;
        }

        public Rect3 toRect3() {
            double d = this.r * Utils.cosd(this.RA) * Utils.cosd(this.Dec);
            double d2 = this.r * Utils.sind(this.RA) * Utils.cosd(this.Dec);
            double d3 = this.r * Utils.sind(this.Dec);
            return new Rect3(d, d2, d3);
        }
    }
}

