/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro;

import com.lavadip.skeye.astro.IntList;

public final class SkyIndex {
    final int NUM_RA_DIVS;
    final int NUM_DEC_DIVS;
    final int MAX_RA_INDEX;
    final int MAX_DEC_INDEX;
    private static final int INITIAL_LIST_SIZE = 32;
    private final IntList[] index;
    private final IntList emptyList = new IntList(0);

    public SkyIndex(int n, int n2) {
        this.NUM_RA_DIVS = n;
        this.NUM_DEC_DIVS = n2;
        this.MAX_RA_INDEX = this.NUM_RA_DIVS - 1;
        this.MAX_DEC_INDEX = this.NUM_DEC_DIVS - 1;
        this.index = new IntList[this.NUM_RA_DIVS * this.NUM_DEC_DIVS];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addObject(int n, float f, float f2) {
        SkyIndex skyIndex = this;
        synchronized (skyIndex) {
            int n2 = this.getBlockIndex(f, f2);
            if (this.index[n2] == null) {
                this.index[n2] = new IntList(32);
            }
            this.index[n2].add(n);
            return n2;
        }
    }

    void logStatistics() {
        for (int i = 0; i < this.NUM_RA_DIVS; ++i) {
            String string = "";
            int n = 0;
            for (int j = 0; j < this.NUM_DEC_DIVS; ++j) {
                IntList intList = this.index[i * this.NUM_DEC_DIVS + j];
                if (intList != null) {
                    n += intList.size;
                    string = string + intList.size + ", ";
                    continue;
                }
                string = string + "0, ";
            }
        }
    }

    public IntList getNeighbours(float f, float f2) {
        int[] nArray = new int[2];
        this.getIndices(f, f2, nArray);
        return this.getNeighbours(nArray[0], nArray[1]);
    }

    private int wrapNext(int n, int n2) {
        return n < n2 ? n + 1 : 0;
    }

    private int wrapPrev(int n, int n2) {
        return n > 0 ? n - 1 : n2;
    }

    private IntList getNeighbours(int n, int n2) {
        IntList intList = new IntList(9);
        int n3 = this.wrapPrev(n, this.MAX_RA_INDEX);
        int n4 = this.wrapPrev(n2, this.MAX_DEC_INDEX);
        int n5 = this.wrapNext(n, this.MAX_RA_INDEX);
        int n6 = this.wrapNext(n2, this.MAX_DEC_INDEX);
        int n7 = this.wrapPrev(n3, this.MAX_RA_INDEX);
        int n8 = this.wrapPrev(n4, this.MAX_DEC_INDEX);
        int n9 = this.wrapNext(n5, this.MAX_RA_INDEX);
        int n10 = this.wrapNext(n6, this.MAX_DEC_INDEX);
        int[] nArray = new int[]{n7, n3, n, n5, n9};
        int[] nArray2 = new int[]{n8, n4, n2, n6, n10};
        for (int n11 : nArray) {
            for (int n12 : nArray2) {
                intList.add(n11 * this.NUM_DEC_DIVS + n12);
            }
        }
        return intList;
    }

    public int getBlockIndex(float f, float f2) {
        int n = (int)(((double)f2 + 1.5707963267948966) * (double)this.NUM_DEC_DIVS / Math.PI);
        if (n == 0 || n == this.NUM_DEC_DIVS - 1) {
            return n;
        }
        int n2 = (int)((double)(f * (float)this.NUM_RA_DIVS) / (Math.PI * 2));
        return n2 * this.NUM_DEC_DIVS + n;
    }

    private void myAssert(boolean bl) {
        if (!bl) {
            throw new RuntimeException();
        }
    }

    private void getIndices(float f, float f2, int[] nArray) {
        int n;
        int n2;
        nArray[1] = n2 = (int)(((double)f2 + 1.5707963267948966) * (double)this.NUM_DEC_DIVS / Math.PI);
        nArray[0] = n2 == 0 || n2 == this.NUM_DEC_DIVS - 1 ? 0 : (n = (int)((double)(f * (float)this.NUM_RA_DIVS) / (Math.PI * 2)));
    }

    public boolean isEmpty(int n) {
        return this.index[n] == null;
    }

    public IntList getObjects(int n) {
        if (this.index[n] == null) {
            return this.emptyList;
        }
        return this.index[n];
    }
}

