/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro;

import com.lavadip.skeye.Vector3d;
import java.util.Date;

final class Precession {
    final double X;
    final double Y;
    final double X2;
    final double Y2;
    final double XY;
    final double A;

    Precession(UTCDate uTCDate) {
        double d = uTCDate.daysSince2000;
        double d2 = 2.182439196616 - 9.242E-4 * d;
        this.X = 2.6603E-7 * d - 3.32E-5 * Math.sin(d2);
        this.Y = -8.14E-14 * d * d + 4.46E-5 * Math.cos(d2);
        this.X2 = this.X * this.X;
        this.Y2 = this.Y * this.Y;
        this.XY = this.X * this.Y;
        this.A = 0.5 + 0.125 * (this.X2 + this.Y2);
    }

    Vector3d applyRotationCIRS(Vector3d vector3d) {
        return new Vector3d((float)(vector3d.x - vector3d.z * this.X), (float)(vector3d.y - vector3d.z * this.Y), (float)(vector3d.x * this.X + vector3d.y * this.Y + vector3d.z), true);
    }

    float[] getTransformMatrix() {
        float[] fArray = new float[]{(float)(1.0 - this.Y2 * this.A), (float)this.Y, (float)(-(this.XY * this.A)), 0.0f, (float)(-this.Y), (float)(1.0 - (this.X2 + this.Y2) * this.A), (float)(-this.X), 0.0f, (float)(-(this.XY * this.A)), (float)this.X, (float)(1.0 - this.X2 * this.A), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return fArray;
    }

    static final class UTCDate {
        final int year;
        final int month;
        final int day;
        final int hours;
        final int mins;
        final int secs;
        final double daysSince2000;
        static final Date J2000Java = UTCDate.makeJavaUTCDate(100, 0, 1, 12, 0, 0);

        UTCDate(int n, int n2, int n3, int n4, int n5, int n6) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            this.hours = n4;
            this.mins = n5;
            this.secs = n6;
            this.daysSince2000 = this.getDaysSince2000();
        }

        private double getDaysSince2000() {
            return (double)(UTCDate.makeJavaUTCDate(this.year, this.month, this.day, this.hours, this.mins, this.secs).getTime() - J2000Java.getTime()) / 8.64E7;
        }

        UTCDate(Date date) {
            long l = (long)date.getTimezoneOffset() * 60000L;
            Date date2 = new Date(date.getTime() + l);
            this.year = date2.getYear();
            this.month = date2.getMonth();
            this.day = date2.getDate();
            this.hours = date2.getHours();
            this.mins = date2.getMinutes();
            this.secs = date2.getSeconds();
            this.daysSince2000 = this.getDaysSince2000();
        }

        static Date makeJavaUTCDate(int n, int n2, int n3, int n4, int n5, int n6) {
            return new Date(Date.UTC(n, n2, n3, n4, n5, n6));
        }

        public String toString() {
            return String.format("Y:%d M:%d D:%d h:%d m:%d s:%d", this.year, this.month, this.day, this.hours, this.mins, this.secs);
        }
    }
}

