/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro;

import com.lavadip.skeye.AstroUtil;
import com.lavadip.skeye.astro.PlanetInfo;
import java.util.Date;

final class Planets {
    static final double RADS = Math.PI / 180;
    public static final int SUN_INDEX = 0;
    public static final int MOON_INDEX = 1;
    public static final int NUM_PLANETS = 9;
    private static final double EARTH_EQ_RADIUS_KM = 6378.137;
    private static final double TWO_PI = Math.PI * 2;
    public static final int lrRowSize = 6;
    public static final int LR_ND = 0;
    public static final int LR_NM = 1;
    public static final int LR_NM1 = 2;
    public static final int LR_NF = 3;
    public static final int LR_LI = 4;
    public static final int LR_RI = 5;
    public static final int[] lrData = new int[]{0, 0, 1, 0, 6288774, -20905355, 2, 0, -1, 0, 1274027, -3699111, 2, 0, 0, 0, 658314, -2955968, 0, 0, 2, 0, 213618, -569925, 0, 1, 0, 0, -185116, 48888, 0, 0, 0, 2, -114332, -3149, 2, 0, -2, 0, 58793, 246158, 2, -1, -1, 0, 57066, -152138, 2, 0, 1, 0, 53322, -170733, 2, -1, 0, 0, 45758, -204586, 0, 1, -1, 0, -40923, -129620, 1, 0, 0, 0, -34720, 108743, 0, 1, 1, 0, -30383, 104755, 2, 0, 0, -2, 15327, 10321, 0, 0, 1, 2, -12528, 0, 0, 0, 1, -2, 10980, 79661, 4, 0, -1, 0, 10675, -34782, 0, 0, 3, 0, 10034, -23210, 4, 0, -2, 0, 8548, -21636, 2, 1, -1, 0, -7888, 24208, 2, 1, 0, 0, -6766, 30824, 1, 0, -1, 0, -5163, -8379, 1, 1, 0, 0, 4987, -16675, 2, -1, 1, 0, 4036, -12831, 2, 0, 2, 0, 3994, -10445, 4, 0, 0, 0, 3861, -11650, 2, 0, -3, 0, 3665, 14403, 0, 1, -2, 0, -2689, -7003, 2, 0, -1, 2, -2602, 0, 2, -1, -2, 0, 2390, 10056, 1, 0, 1, 0, -2348, 6322, 2, -2, 0, 0, 2236, -9884, 0, 1, 2, 0, -2120, 5751, 0, 2, 0, 0, -2069, 0, 2, -2, -1, 0, 2048, -4950, 2, 0, 1, -2, -1773, 4130, 2, 0, 0, 2, -1595, 0, 4, -1, -1, 0, 1215, -3958, 0, 0, 2, 2, -1110, 0, 3, 0, -1, 0, -892, 3258, 2, 1, 1, 0, -810, 2616, 4, -1, -2, 0, 759, -1897, 0, 2, -1, 0, -713, -2117, 2, 2, -1, 0, -700, 2354, 2, 1, -2, 0, 691, 0, 2, -1, 0, -2, 596, 0, 4, 0, 1, 0, 549, -1423, 0, 0, 4, 0, 537, -1117, 4, -1, 0, 0, 520, -1571, 1, 0, -2, 0, -487, -1739, 2, 1, 0, -2, -399, 0, 0, 0, 2, -2, -381, -4421, 1, 1, 1, 0, 351, 0, 3, 0, -2, 0, -340, 0, 4, 0, -3, 0, 330, 0, 2, -1, 2, 0, 327, 0, 0, 2, 1, 0, -323, 1165, 1, 1, -1, 0, 299, 0, 2, 0, 3, 0, 294, 0, 2, 0, -1, -2, 0, 8752};
    public static final int bRowSize = 5;
    public static final int B_ND = 0;
    public static final int B_NM = 1;
    public static final int B_NM1 = 2;
    public static final int B_NF = 3;
    public static final int B_BI = 4;
    public static int[] bData = new int[]{0, 0, 0, 1, 5128122, 0, 0, 1, 1, 280602, 0, 0, 1, -1, 277693, 2, 0, 0, -1, 173237, 2, 0, -1, 1, 55413, 2, 0, -1, -1, 46271, 2, 0, 0, 1, 32573, 0, 0, 2, 1, 17198, 2, 0, 1, -1, 9266, 0, 0, 2, -1, 8822, 2, -1, 0, -1, 8216, 2, 0, -2, -1, 4324, 2, 0, 1, 1, 4200, 2, 1, 0, -1, -3359, 2, -1, -1, 1, 2463, 2, -1, 0, 1, 2211, 2, -1, -1, -1, 2065, 0, 1, -1, -1, -1870, 4, 0, -1, -1, 1828, 0, 1, 0, 1, -1794, 0, 0, 0, 3, -1749, 0, 1, -1, 1, -1565, 1, 0, 0, 1, -1491, 0, 1, 1, 1, -1475, 0, 1, 1, -1, -1410, 0, 1, 0, -1, -1344, 1, 0, 0, -1, -1335, 0, 0, 3, 1, 1107, 4, 0, 0, -1, 1021, 4, 0, -1, 1, 833, 0, 0, 1, -3, 777, 4, 0, -2, 1, 671, 2, 0, 0, -3, 607, 2, 0, 2, -1, 596, 2, -1, 1, -1, 491, 2, 0, -2, 1, -451, 0, 0, 3, -1, 439, 2, 0, 2, 1, 422, 2, 0, -3, -1, 421, 2, 1, -1, 1, -366, 2, 1, 0, 1, -351, 4, 0, 0, 1, 331, 2, -1, 1, 1, 315, 2, -2, 0, -1, 302, 0, 0, 1, 3, -283, 2, 1, 1, -1, -229, 1, 1, 0, -1, 223, 1, 1, 0, 1, 223, 0, 1, -2, -1, -220, 2, 1, -1, -1, -220, 1, 0, 1, 1, -185, 2, -1, -2, -1, 181, 0, 1, 2, 1, -177, 4, 0, -2, -1, 176, 4, -1, -1, -1, 166, 1, 0, 1, -1, -164, 4, 0, 1, -1, 132, 1, 0, -1, -1, -119, 4, -1, 0, -1, 115, 2, -2, 0, 1, 107};
    private final Date forDate;
    private final double lmst;
    private final double ecl;
    private final float userLatitude;
    private final double d;
    private final PlanetInfo sunInfo;

    public Planets(Date date, double d, float f) {
        this.forDate = date;
        this.lmst = d;
        this.userLatitude = f;
        this.d = Planets.localJDayNum(date);
        this.ecl = Math.toRadians(23.4393 - 3.563E-7 * this.d);
        this.sunInfo = new PlanetInfo(0.0, 0.0, Math.toRadians(282.9404 + 4.70935E-5 * this.d), 1.0, 0.016709 - 1.151E-9 * this.d, Math.toRadians(356.047 + 0.9856002585 * this.d), this.d, this.ecl);
    }

    private static double localJulianDate(Date date) {
        return Planets.localJDayNum(date) - 1.5;
    }

    private static double[] moonPosition(Date date, double d, double d2) {
        int n;
        int n2;
        int n3;
        int n4;
        double d3 = Planets.localJulianDate(date) / 36525.0;
        double d4 = 1.0 - 0.002516 * d3 - 7.4E-6 * d3 * d3;
        double d5 = Math.PI / 180 * (218.3164591 + 481267.88134236 * d3 - 0.0013268 * d3 * d3 + d3 * d3 * d3 / 538841.0 - d3 * d3 * d3 * d3 / 6.5194E7);
        double d6 = Math.PI / 180 * (297.8502042 + 445267.1115168 * d3 - 0.00163 * d3 * d3 + d3 * d3 * d3 / 545868.0 - d3 * d3 * d3 * d3 / 1.13065E8);
        double d7 = Math.PI / 180 * (357.5291092 + 35999.0502909 * d3 - 1.536E-4 * d3 * d3 + d3 * d3 * d3 / 2.449E7);
        double d8 = Math.PI / 180 * (134.9634114 + 477198.8676313 * d3 + 0.008997 * d3 * d3 + d3 * d3 * d3 / 69699.0 - d3 * d3 * d3 * d3 / 1.4712E7);
        double d9 = Math.PI / 180 * (93.2720993 + 483202.0175273 * d3 - 0.0034029 * d3 * d3 - d3 * d3 * d3 / 3526000.0 + d3 * d3 * d3 * d3 / 8.6331E8);
        double d10 = Math.PI / 180 * (119.75 + 131.849 * d3);
        double d11 = Math.PI / 180 * (53.09 + 479264.29 * d3);
        double d12 = Math.PI / 180 * (313.45 + 481226.484 * d3);
        double d13 = 0.0;
        double d14 = 0.0;
        for (int i = 0; i < lrData.length / 6; ++i) {
            int n5 = i * 6;
            double d15 = 1.0;
            int n6 = lrData[n5 + 1];
            int n7 = lrData[n5 + 2];
            n4 = lrData[n5 + 3];
            n3 = lrData[n5 + 0];
            n2 = lrData[n5 + 4];
            n = lrData[n5 + 5];
            if (n6 != 0) {
                d15 = d4;
                if (Math.abs(n6) == 2) {
                    d15 *= d15;
                }
            }
            d13 += d15 * (double)n2 * Math.sin((double)n3 * d6 + (double)n6 * d7 + (double)n7 * d8 + (double)n4 * d9);
            d14 += d15 * (double)n * Math.cos((double)n3 * d6 + (double)n6 * d7 + (double)n7 * d8 + (double)n4 * d9);
        }
        double d16 = 0.0;
        for (int i = 0; i < bData.length / 5; ++i) {
            int n8 = i * 5;
            double d17 = 1.0;
            n4 = bData[n8 + 1];
            n3 = bData[n8 + 2];
            n2 = bData[n8 + 0];
            n = bData[n8 + 3];
            int n9 = bData[n8 + 4];
            if (n4 != 0) {
                d17 = d4;
                if (Math.abs(n4) == 2) {
                    d17 *= d17;
                }
            }
            d16 += d17 * (double)n9 * Math.sin((double)n2 * d6 + (double)n4 * d7 + (double)n3 * d8 + (double)n * d9);
        }
        double d18 = Math.PI / 180 * (d13 += 3958.0 * Math.sin(d10) + 1962.0 * Math.sin(d5 - d9) + 318.0 * Math.sin(d11)) / 1000000.0 + d5;
        double d19 = Math.PI / 180 * (d16 += -2235.0 * Math.sin(d5) + 382.0 * Math.sin(d12) + 175.0 * Math.sin(d10 - d9) + 175.0 * Math.sin(d10 + d9) + 127.0 * Math.sin(d5 - d8) - 115.0 * Math.sin(d5 + d8)) / 1000000.0;
        double[] dArray = Planets.eclipticToEquatorial(d18, d19, d3);
        double d20 = dArray[0] % (Math.PI * 2);
        double d21 = dArray[1] % (Math.PI * 2);
        double d22 = (385000.56 + d14 / 1000.0) / 6378.137;
        double d23 = Math.asin(1.0 / d22);
        double d24 = d2;
        double d25 = 0.99833 + 0.00167 * Math.cos(2.0 * d2);
        double d26 = d - d20;
        double d27 = Math.atan2(Math.tan(d24), Math.cos(d26));
        double d28 = d20 - d23 * d25 * Math.cos(d24) * Math.sin(d26) / Math.cos(d21);
        double d29 = d27 == 0.0 ? d21 - d23 * d25 * Math.sin(d21) * Math.cos(d26) : d21 - d23 * d25 * Math.sin(d24) * Math.sin(d27 - d21) / Math.sin(d27);
        return new double[]{AstroUtil.makeAnglePositive(d28), d29};
    }

    private static double[] eclipticToEquatorial(double d, double d2, double d3) {
        double d4 = d3 / 100.0;
        double d5 = -4680.93 * d4 - 1.55 * d4 * d4 + 1999.25 * d4 * d4 * d4 - 51.38 * d4 * d4 * d4 * d4 - 249.67 * d4 * d4 * d4 * d4 * d4 - 39.05 * d4 * d4 * d4 * d4 * d4 * d4 + 7.12 * d4 * d4 * d4 * d4 * d4 * d4 * d4 + 27.87 * d4 * d4 * d4 * d4 * d4 * d4 * d4 * d4 + 5.79 * d4 * d4 * d4 * d4 * d4 * d4 * d4 * d4 * d4 + 2.45 * d4 * d4 * d4 * d4 * d4 * d4 * d4 * d4 * d4 * d4;
        double d6 = Math.PI / 180 * (23.43929111 + d5 / 3600.0);
        double d7 = Math.cos(d) * Math.cos(d2);
        double d8 = Math.sin(d) * Math.cos(d2);
        double d9 = Math.sin(d2);
        double d10 = d7;
        double d11 = d8 * Math.cos(d6) - d9 * Math.sin(d6);
        double d12 = d8 * Math.sin(d6) + d9 * Math.cos(d6);
        return new double[]{Math.atan2(d11, d10), Math.asin(d12)};
    }

    public static double localJDayNum(Date date) {
        int n = date.getMonth() + 1;
        int n2 = date.getYear() + 1900;
        int n3 = date.getDate();
        int n4 = date.getTimezoneOffset();
        double d = (double)date.getHours() + (double)(date.getMinutes() + n4) / 60.0;
        return (double)(367 * n2 - 7 * (n2 + (n + 9) / 12) / 4 + 275 * n / 9 + n3 - 730530) + d / 24.0;
    }

    private static void storeInArray(double[] dArray, double[] dArray2, int n) {
        dArray2[n] = dArray[0];
        dArray2[n + 1] = dArray[1];
    }

    public double[] getSunPosition() {
        return this.sunInfo.getSunPosition();
    }

    public double[] getPlanetPositions() {
        double[] dArray = new double[18];
        Planets.storeInArray(this.sunInfo.getSunPosition(), dArray, 0);
        Planets.storeInArray(Planets.moonPosition(this.forDate, this.lmst, this.userLatitude), dArray, 2);
        PlanetInfo planetInfo = new PlanetInfo(Math.toRadians(48.3313 + 3.24587E-5 * this.d), Math.toRadians(7.0047 + 5.0E-8 * this.d), Math.toRadians(29.1241 + 1.01444E-5 * this.d), 0.387098, 0.205635 + 5.59E-10 * this.d, Math.toRadians(168.6562 + 4.0923344368 * this.d), this.d, this.ecl);
        PlanetInfo planetInfo2 = new PlanetInfo(Math.toRadians(76.6799 + 2.4659E-5 * this.d), Math.toRadians(3.3946 + 2.75E-8 * this.d), Math.toRadians(54.891 + 1.38374E-5 * this.d), 0.72333, 0.006773 - 1.302E-9 * this.d, Math.toRadians(48.0052 + 1.6021302244 * this.d), this.d, this.ecl);
        PlanetInfo planetInfo3 = new PlanetInfo(Math.toRadians(49.5574 + 2.11081E-5 * this.d), Math.toRadians(1.8497 - 1.78E-8 * this.d), Math.toRadians(286.5016 + 2.92961E-5 * this.d), 1.523688, 0.093405 + 2.516E-9 * this.d, Math.toRadians(18.6021 + 0.5240207766 * this.d), this.d, this.ecl);
        PlanetInfo planetInfo4 = new PlanetInfo(Math.toRadians(100.4542 + 2.76854E-5 * this.d), Math.toRadians(1.303 - 1.557E-7 * this.d), Math.toRadians(273.8777 + 1.64505E-5 * this.d), 5.20256, 0.048498 + 4.469E-9 * this.d, Math.toRadians(19.895 + 0.0830853001 * this.d), this.d, this.ecl);
        PlanetInfo planetInfo5 = new PlanetInfo(Math.toRadians(113.6634 + 2.3898E-5 * this.d), Math.toRadians(2.4886 - 1.081E-7 * this.d), Math.toRadians(339.3939 + 2.97661E-5 * this.d), 9.55475, 0.055546 - 9.499E-9 * this.d, Math.toRadians(316.967 + 0.0334442282 * this.d), this.d, this.ecl);
        PlanetInfo planetInfo6 = new PlanetInfo(Math.toRadians(74.0005 + 1.3978E-5 * this.d), Math.toRadians(0.7733 + 1.9E-8 * this.d), Math.toRadians(96.6612 + 3.0565E-5 * this.d), 19.18171 - 1.55E-8 * this.d, 0.047318 + 7.45E-9 * this.d, Math.toRadians(142.5905 + 0.011725806 * this.d), this.d, this.ecl);
        PlanetInfo planetInfo7 = new PlanetInfo(Math.toRadians(131.7806 + 3.0173E-5 * this.d), Math.toRadians(1.77 - 2.55E-7 * this.d), Math.toRadians(272.8461 - 6.027E-6 * this.d), 30.05826 + 3.313E-8 * this.d, 0.008606 + 2.15E-9 * this.d, Math.toRadians(260.2471 + 0.005995147 * this.d), this.d, this.ecl);
        Planets.storeInArray(planetInfo.getPlanetEquatorialPos(this.sunInfo), dArray, 4);
        Planets.storeInArray(planetInfo2.getPlanetEquatorialPos(this.sunInfo), dArray, 6);
        Planets.storeInArray(planetInfo3.getPlanetEquatorialPos(this.sunInfo), dArray, 8);
        planetInfo4.addPerturbationToJupiter(planetInfo5);
        Planets.storeInArray(planetInfo4.getPlanetEquatorialPos(this.sunInfo), dArray, 10);
        planetInfo5.addPerturbationToSaturn(planetInfo4);
        Planets.storeInArray(planetInfo5.getPlanetEquatorialPos(this.sunInfo), dArray, 12);
        planetInfo6.addPerturbationToUranus(planetInfo5, planetInfo4);
        Planets.storeInArray(planetInfo6.getPlanetEquatorialPos(this.sunInfo), dArray, 14);
        Planets.storeInArray(planetInfo7.getPlanetEquatorialPos(this.sunInfo), dArray, 16);
        return dArray;
    }
}

