/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro;

import com.lavadip.skeye.AstroUtil;

final class PlanetInfo {
    private double mLongEcl;
    private double mLatEcl;
    private final double mR;
    private final double ecl;
    double MeanAnomaly;

    public PlanetInfo(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        this.ecl = d8;
        this.MeanAnomaly = d6;
        double d11 = d10 = d6 + d5 * Math.sin(d6) * (1.0 + d5 * Math.cos(d6));
        int n = 0;
        while (Math.abs((d11 = (d10 = d11) - (d10 - d5 * Math.sin(d10) - d6) / (1.0 - d5 * Math.cos(d10))) - d10) > 1.0E-7 && ++n < 1000) {
        }
        double d12 = d4 * (Math.cos(d11) - d5);
        double d13 = d4 * (Math.sin(d11) * Math.sqrt(1.0 - d5 * d5));
        double d14 = Math.atan2(d13, d12);
        this.mR = d9 = Math.sqrt(d12 * d12 + d13 * d13);
        double d15 = Math.sin(d14 + d3) * Math.cos(d2);
        double d16 = Math.cos(d14 + d3);
        double d17 = d9 * (Math.cos(d) * d16 - Math.sin(d) * d15);
        double d18 = d9 * (Math.sin(d) * d16 + Math.cos(d) * d15);
        double d19 = d9 * (Math.sin(d14 + d3) * Math.sin(d2));
        double d20 = Math.atan2(d18, d17);
        double d21 = Math.atan2(d19, Math.sqrt(d17 * d17 + d18 * d18));
        double d22 = Math.toRadians(3.82394E-5 * -d7);
        this.mLongEcl = d20 + d22;
        this.mLatEcl = d21;
    }

    double[] getPlanetEquatorialPos(PlanetInfo planetInfo) {
        double d = this.mR * Math.cos(this.mLongEcl) * Math.cos(this.mLatEcl);
        double d2 = this.mR * Math.sin(this.mLongEcl) * Math.cos(this.mLatEcl);
        double d3 = this.mR * Math.sin(this.mLatEcl);
        double d4 = planetInfo.mR * Math.cos(planetInfo.mLongEcl);
        double d5 = planetInfo.mR * Math.sin(planetInfo.mLongEcl);
        double d6 = d + d4;
        double d7 = d2 + d5;
        double d8 = d3;
        double d9 = Math.cos(this.ecl);
        double d10 = Math.sin(this.ecl);
        double d11 = d6;
        double d12 = d7 * d9 - d8 * d10;
        double d13 = d7 * d10 + d8 * d9;
        return this.getRADec(d11, d12, d13);
    }

    double[] getSunPosition() {
        double d = Math.cos(this.mLongEcl);
        double d2 = Math.sin(this.mLongEcl);
        double d3 = d;
        double d4 = d2 * Math.cos(this.ecl);
        double d5 = d2 * Math.sin(this.ecl);
        return this.getRADec(d3, d4, d5);
    }

    private double[] getRADec(double d, double d2, double d3) {
        double d4 = Math.atan2(d2, d);
        double d5 = Math.atan2(d3, Math.sqrt(d * d + d2 * d2));
        return new double[]{AstroUtil.makeAnglePositive(d4), d5};
    }

    public void addPerturbationToJupiter(PlanetInfo planetInfo) {
        double d = this.MeanAnomaly;
        double d2 = planetInfo.MeanAnomaly;
        double d3 = -0.332 * Math.sin(2.0 * d - 5.0 * d2 - Math.toRadians(67.6)) - 0.056 * Math.sin(2.0 * d - 2.0 * d2 + Math.toRadians(21.0)) + 0.042 * Math.sin(3.0 * d - 5.0 * d2 + Math.toRadians(21.0)) - 0.036 * Math.sin(d - 2.0 * d2) + 0.022 * Math.cos(d - d2) + 0.023 * Math.sin(2.0 * d - 3.0 * d2 + Math.toRadians(52.0)) - 0.016 * Math.sin(d - 5.0 * d2 - Math.toRadians(69.0));
        this.mLongEcl += Math.toRadians(d3);
    }

    public void addPerturbationToSaturn(PlanetInfo planetInfo) {
        double d = planetInfo.MeanAnomaly;
        double d2 = this.MeanAnomaly;
        double d3 = 0.812 * Math.sin(2.0 * d - 5.0 * d2 - Math.toRadians(67.6)) - 0.229 * Math.cos(2.0 * d - 4.0 * d2 - Math.toRadians(2.0)) + 0.119 * Math.sin(d - 2.0 * d2 - Math.toRadians(3.0)) + 0.046 * Math.sin(2.0 * d - 6.0 * d2 - Math.toRadians(69.0)) + 0.014 * Math.sin(d - 3.0 * d2 + Math.toRadians(32.0));
        this.mLongEcl += Math.toRadians(d3);
        double d4 = -0.02 * Math.cos(2.0 * d - 4.0 * d2 - Math.toRadians(2.0)) + 0.018 * Math.sin(2.0 * d - 6.0 * d2 - Math.toRadians(49.0));
        this.mLatEcl += Math.toRadians(d4);
    }

    public void addPerturbationToUranus(PlanetInfo planetInfo, PlanetInfo planetInfo2) {
        double d = this.MeanAnomaly;
        double d2 = planetInfo2.MeanAnomaly;
        double d3 = planetInfo.MeanAnomaly;
        double d4 = 0.04 * Math.sin(d3 - 2.0 * d + Math.toRadians(6.0)) + 0.035 * Math.sin(d3 - 3.0 * d + Math.toRadians(33.0)) - 0.015 * Math.sin(d2 - d + Math.toRadians(20.0));
        this.mLongEcl += Math.toRadians(d4);
    }
}

