/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro;

import java.util.Arrays;

public final class IntList {
    public static final IntList ALWAYS_EMPTY_LIST = new IntList(0);
    protected int[] data;
    public transient int size = 0;

    public boolean equals(Object object) {
        if (IntList.class.isInstance(object)) {
            IntList intList = (IntList)object;
            if (this.size == intList.size) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.data[i] == intList.data[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public IntList(int n) {
        this.data = new int[n];
    }

    public void clearList() {
        this.size = 0;
    }

    public int get(int n) {
        return this.data[n];
    }

    public void add(int n) {
        if (this.data.length == this.size) {
            this.resize(this.data.length * 2);
        }
        this.data[this.size++] = n;
    }

    public boolean addUnique(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != n) continue;
            return false;
        }
        this.add(n);
        return true;
    }

    public void addUnique(IntList intList) {
        int n = intList.size;
        for (int i = 0; i < n; ++i) {
            this.addUnique(intList.get(i));
        }
    }

    protected void resize(int n) {
        int[] nArray = new int[n];
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        this.data = nArray;
    }

    public String toString() {
        String string = "IntList: [";
        for (int i = 0; i < this.size; ++i) {
            string = string + this.data[i] + ", ";
        }
        return string + "]";
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != n) continue;
            return true;
        }
        return false;
    }

    public void sortAscending() {
        Arrays.sort(this.data, 0, this.size);
    }

    public IntList makeCopy() {
        IntList intList = new IntList(this.size);
        System.arraycopy(this.data, 0, intList.data, 0, this.size);
        intList.size = this.size;
        return intList;
    }

    public void set(int n, int n2) {
        if (n >= this.data.length) {
            this.resize(Math.max(this.data.length << 1, n + 2));
        }
        if (n > this.size) {
            this.size = n;
        }
        this.data[n] = n2;
    }
}

