/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro;

public final class Instant {
    private final int year;
    private final int month;
    private final int day;
    private final double dayFraction;

    public Instant(int n, int n2, int n3, double d) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.dayFraction = d;
    }

    public Instant(int n, int n2, double d) {
        this.year = n;
        this.month = n2;
        this.day = (int)d;
        this.dayFraction = d - (double)this.day;
    }

    public double getJulianDay() {
        int n = this.year;
        int n2 = this.month;
        int n3 = this.day;
        long l = n3 - 32075 + 1461 * (n + 4800 + (n2 - 14) / 12) / 4 + 367 * (n2 - 2 - (n2 - 14) / 12 * 12) / 12 - 3 * ((n + 4900 + (n2 - 14) / 12) / 100) / 4;
        return (double)l + (this.dayFraction - 0.5);
    }

    public double getSiderealYears() {
        return 0.002737803091986241 * this.getJulianDay();
    }

    public double getDaysJ2000() {
        long l = this.year;
        int n = this.month;
        int n2 = this.day;
        long l2 = 367L * l - 7L * (l + (long)((n + 9) / 12)) / 4L + (long)(275 * n / 9) + (long)n2 - 730530L;
        return (double)l2 + (this.dayFraction - 0.5);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.day;
        long l = Double.doubleToLongBits(this.dayFraction);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + this.month;
        n = 31 * n + this.year;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Instant instant = (Instant)object;
        if (this.day != instant.day) {
            return false;
        }
        if (Double.doubleToLongBits(this.dayFraction) != Double.doubleToLongBits(instant.dayFraction)) {
            return false;
        }
        if (this.month != instant.month) {
            return false;
        }
        return this.year == instant.year;
    }

    public String formatYYYYMMDD() {
        return String.format("%4d %2d %2d UT", this.year, this.month, this.day);
    }
}

