/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro;

import com.lavadip.skeye.AstroUtil;
import com.lavadip.skeye.astro.Comet;
import com.lavadip.skeye.astro.Instant;
import com.lavadip.skeye.astro.keplerian.Elements;
import com.lavadip.skeye.astro.keplerian.EllipticalOrbit;
import com.lavadip.skeye.astro.keplerian.HyperbolicOrbit;
import com.lavadip.skeye.astro.keplerian.ParabolicOrbit;
import fortranfmt.FortranFormat;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;

public final class CometParser {
    private static final String[] specParts = new String[]{"I4", "A1", "A7", "2X", "I4", "1X", "I2", "1X", "F7.4", "1X", "F9.6", "2X", "F8.6", "2X", "F8.4", "2X", "F8.4", "2X", "F8.4", "2X", "I4", "I2", "I2", "2X", "F4.1", "1X", "F4.0", "2X", "A56", "1X", "A9"};

    public static Comet parseComet(FortranFormat fortranFormat, String string) throws IOException {
        ArrayList arrayList = fortranFormat.parse(string);
        double d = (Double)arrayList.get(7);
        Elements elements = new Elements(new Instant((Integer)arrayList.get(3), (Integer)arrayList.get(4), (Double)arrayList.get(5)), (Double)arrayList.get(6), 0.0, d, Math.toRadians((Double)arrayList.get(10)), Math.toRadians((Double)arrayList.get(9)), Math.toRadians((Double)arrayList.get(8)));
        EllipticalOrbit ellipticalOrbit = d < 1.0 ? new EllipticalOrbit(elements) : (d == 1.0 ? new ParabolicOrbit(elements) : new HyperbolicOrbit(elements));
        return new Comet((String)arrayList.get(16), (Double)arrayList.get(14), (Double)arrayList.get(15), ellipticalOrbit);
    }

    public static Comet[] parseComets(String[] stringArray) {
        ArrayList<Comet> arrayList = new ArrayList<Comet>(stringArray.length);
        try {
            FortranFormat fortranFormat = CometParser.mkParser();
            for (String string : stringArray) {
                try {
                    arrayList.add(CometParser.parseComet(fortranFormat, string));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (ParseException parseException) {
            throw new UnknownError("Error while initialising");
        }
        return arrayList.toArray(new Comet[arrayList.size()]);
    }

    public static Comet[] parseComets(Iterable<String> iterable) {
        ArrayList<Comet> arrayList = new ArrayList<Comet>();
        try {
            FortranFormat fortranFormat = CometParser.mkParser();
            for (String string : iterable) {
                try {
                    arrayList.add(CometParser.parseComet(fortranFormat, string));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (ParseException parseException) {
            throw new UnknownError("Error while initialising");
        }
        return arrayList.toArray(new Comet[arrayList.size()]);
    }

    private static FortranFormat mkParser() throws ParseException {
        String string = "(" + AstroUtil.mkString(specParts, ",") + ")";
        FortranFormat fortranFormat = new FortranFormat(string);
        return fortranFormat;
    }
}

