/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye.astro;

import com.lavadip.skeye.astro.Instant;
import com.lavadip.skeye.astro.keplerian.Orbit;

public final class Comet {
    public final String name;
    public final double absoluteMagnitude;
    public final double slope;
    public final Orbit orbit;

    public Comet(String string, double d, double d2, Orbit orbit) {
        this.name = string;
        this.absoluteMagnitude = d;
        this.slope = d2;
        this.orbit = orbit;
    }

    public CometData getDataForInstant(Instant instant) {
        Orbit.OrbitInstantData orbitInstantData = this.orbit.getGeoentricPosition(instant);
        double d = this.absoluteMagnitude + 5.0 * Math.log10(orbitInstantData.geocentricDistance) + 2.5 * this.slope * Math.log10(orbitInstantData.heliocentricDistance);
        return new CometData(instant, d, orbitInstantData);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.absoluteMagnitude);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.orbit == null ? 0 : this.orbit.hashCode());
        l = Double.doubleToLongBits(this.slope);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Comet comet = (Comet)object;
        if (Double.doubleToLongBits(this.absoluteMagnitude) != Double.doubleToLongBits(comet.absoluteMagnitude)) {
            return false;
        }
        if (this.name == null ? comet.name != null : !this.name.equals(comet.name)) {
            return false;
        }
        if (this.orbit == null ? comet.orbit != null : !this.orbit.equals(comet.orbit)) {
            return false;
        }
        return Double.doubleToLongBits(this.slope) == Double.doubleToLongBits(comet.slope);
    }

    public static class CometData {
        public final Instant t;
        public final double apparentMagnitude;
        public final Orbit.OrbitInstantData posData;

        public CometData(Instant instant, double d, Orbit.OrbitInstantData orbitInstantData) {
            this.t = instant;
            this.apparentMagnitude = d;
            this.posData = orbitInstantData;
        }
    }
}

