/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public final class Vector3d {
    public double x;
    public double y;
    public double z;

    public Vector3d(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3d(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public void setXYZ(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void setXYZ(DoubleBuffer doubleBuffer, int n) {
        this.x = doubleBuffer.get(n);
        this.y = doubleBuffer.get(n + 1);
        this.z = doubleBuffer.get(n + 2);
    }

    public void setXYZ(FloatBuffer floatBuffer, int n) {
        this.x = floatBuffer.get(n);
        this.y = floatBuffer.get(n + 1);
        this.z = floatBuffer.get(n + 2);
    }

    public void putXYZ(FloatBuffer floatBuffer) {
        floatBuffer.put((float)this.x);
        floatBuffer.put((float)this.y);
        floatBuffer.put((float)this.z);
    }

    public void putXYZ(FloatBuffer floatBuffer, double d) {
        floatBuffer.put((float)(this.x * d));
        floatBuffer.put((float)(this.y * d));
        floatBuffer.put((float)(this.z * d));
    }

    public void putXYZ(float[] fArray, int n, double d) {
        fArray[n] = (float)(this.x * d);
        fArray[n + 1] = (float)(this.y * d);
        fArray[n + 2] = (float)(this.z * d);
    }

    public void setXYZ(double[] dArray, int n) {
        this.x = dArray[n];
        this.y = dArray[n + 1];
        this.z = dArray[n + 2];
    }

    public void setXYZ(float[] fArray, int n) {
        this.x = fArray[n];
        this.y = fArray[n + 1];
        this.z = fArray[n + 2];
    }

    public Vector3d(double[] dArray, int n) {
        this.x = -dArray[n];
        this.y = -dArray[n + 4];
        this.z = -dArray[n + 8];
        this.normalise();
    }

    public Vector3d(float[] fArray, int n) {
        this.x = -fArray[n];
        this.y = -fArray[n + 4];
        this.z = -fArray[n + 8];
        this.normalise();
    }

    public Vector3d() {
    }

    public Vector3d(Vector3d vector3d) {
        this.setXYZ(vector3d.x, vector3d.y, vector3d.z);
    }

    public Vector3d(double d, double d2, double d3, boolean bl) {
        if (bl) {
            double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
            this.x = d / d4;
            this.y = d2 / d4;
            this.z = d3 / d4;
        } else {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }
    }

    public void crossMult(Vector3d vector3d, boolean bl, Vector3d vector3d2) {
        vector3d2.x = this.y * vector3d.z - this.z * vector3d.y;
        vector3d2.y = this.z * vector3d.x - this.x * vector3d.z;
        vector3d2.z = this.x * vector3d.y - this.y * vector3d.x;
        if (bl) {
            vector3d2.normalise();
        }
    }

    public Vector3d crossMult(Vector3d vector3d, boolean bl) {
        Vector3d vector3d2 = new Vector3d();
        this.crossMult(vector3d, bl, vector3d2);
        return vector3d2;
    }

    public void normalise() {
        double d = this.length();
        if (d != 0.0) {
            this.x /= d;
            this.y /= d;
            this.z /= d;
        }
    }

    public Vector3d normalised() {
        Vector3d vector3d = new Vector3d(this);
        vector3d.normalise();
        return vector3d;
    }

    public double dotMult(Vector3d vector3d) {
        return this.x * vector3d.x + this.y * vector3d.y + this.z * vector3d.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double angleBetweenMag(Vector3d vector3d) {
        double d = this.dotMult(vector3d);
        if (d < -1.0) {
            d = -1.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        return Math.acos(d);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public String toString() {
        return String.format("V[%.8f, %.8f, %.8f] len:%.8f", this.x, this.y, this.z, this.length());
    }

    public void rotate(double d, Vector3d vector3d, Vector3d vector3d2) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = vector3d.x;
        double d5 = vector3d.y;
        double d6 = vector3d.z;
        double d7 = d4 * d4;
        double d8 = d5 * d5;
        double d9 = d6 * d6;
        double d10 = this.x * d4 + this.y * d5 + this.z * d6;
        vector3d2.x = d4 * d10 + (this.x * (d8 + d9) - d4 * (d5 * this.y + d6 * this.z)) * d2 + (d5 * this.z - d6 * this.y) * d3;
        vector3d2.y = d5 * d10 + (this.y * (d7 + d9) - d5 * (d4 * this.x + d6 * this.z)) * d2 + (d6 * this.x - d4 * this.z) * d3;
        vector3d2.z = d6 * d10 + (this.z * (d8 + d7) - d6 * (d5 * this.y + d4 * this.x)) * d2 + (d4 * this.y - d5 * this.x) * d3;
    }

    public Vector3d rotateAboutXaxis(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return new Vector3d(this.x, this.y * d2 - this.z * d3, this.z * d2 + this.y * d3);
    }

    public Vector3d rotateAboutYaxis(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return new Vector3d(this.x * d2 + this.z * d3, this.y, this.z * d2 - this.x * d3);
    }

    public Vector3d rotateAboutZaxis(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return new Vector3d(this.x * d2 - this.y * d3, this.y * d2 + this.x * d3, this.z);
    }

    public Vector3d rotate(double d, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d();
        this.rotate(d, vector3d, vector3d2);
        return vector3d2;
    }

    public void rotateAwayFrom(double d, Vector3d vector3d, Vector3d vector3d2) {
        double d2 = vector3d.y * this.z - vector3d.z * this.y;
        double d3 = vector3d.z * this.x - vector3d.x * this.z;
        double d4 = vector3d.x * this.y - vector3d.y * this.x;
        double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = d2 / d5;
        double d9 = d3 / d5;
        double d10 = d4 / d5;
        vector3d2.x = this.x * d6 + (d9 * this.z - d10 * this.y) * d7;
        vector3d2.y = this.y * d6 + (d10 * this.x - d8 * this.z) * d7;
        vector3d2.z = this.z * d6 + (d8 * this.y - d9 * this.x) * d7;
    }

    public Vector3d rotateAwayFrom(double d, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d();
        this.rotateAwayFrom(d, vector3d, vector3d2);
        return vector3d2;
    }

    void copyFrom(Vector3d vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
    }

    public void scalarMultiplyInPlace(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public Vector3d scalarMultiply(double d) {
        return new Vector3d(this.x * d, this.y * d, this.z * d);
    }

    public Vector3d add(Vector3d vector3d) {
        return new Vector3d(this.x + vector3d.x, this.y + vector3d.y, this.z + vector3d.z);
    }

    public Vector3d sub(Vector3d vector3d) {
        return new Vector3d(this.x - vector3d.x, this.y - vector3d.y, this.z - vector3d.z);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector3d vector3d = (Vector3d)object;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(vector3d.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(vector3d.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(vector3d.z);
    }

    public String serializeToString() {
        return String.format("%.2f,%.2f,%.2f", this.x, this.y, this.z);
    }
}

