/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye;

public final class Vector2d {
    public double x;
    public double y;

    public Vector2d(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vector2d(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void setXYZ(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setXYZ(double[] dArray, int n) {
        this.x = dArray[n];
        this.y = dArray[n + 1];
    }

    public void setXYZ(float[] fArray, int n) {
        this.x = fArray[n];
        this.y = fArray[n + 1];
    }

    public Vector2d(Vector2d vector2d) {
        this.setXYZ(vector2d.x, vector2d.y);
    }

    public Vector2d(double d, double d2, boolean bl) {
        if (bl) {
            double d3 = Math.sqrt(d * d + d2 * d2);
            this.x = d / d3;
            this.y = d2 / d3;
        } else {
            this.x = d;
            this.y = d2;
        }
    }

    public void normalise() {
        double d = this.length();
        if (d != 0.0) {
            this.x /= d;
            this.y /= d;
        }
    }

    public double dotMult(Vector2d vector2d) {
        return this.x * vector2d.x + this.y * vector2d.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double angleBetweenMag(Vector2d vector2d) {
        double d = this.dotMult(vector2d);
        if (d < -1.0) {
            d = -1.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        return Math.acos(d);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public String toString() {
        return String.format("V[%.8f, %.8f] len:%.8f", this.x, this.y, this.length());
    }

    void copyFrom(Vector2d vector2d) {
        this.x = vector2d.x;
        this.y = vector2d.y;
    }

    void scalarMultiply(double d) {
        this.x *= d;
        this.y *= d;
    }
}

