/*
 * Decompiled with CFR 0.152.
 */
package com.lavadip.skeye;

import com.lavadip.skeye.Vector3d;

public final class AstroUtil {
    private static final double TO_RADIANS = Math.PI / 180;
    public static final double PI_BY2 = 1.5707963267948966;
    public static final double TWO_PI = Math.PI * 2;

    public static double toRadians(double d) {
        return Math.PI / 180 * d;
    }

    public static double truncRad(double d) {
        return ((Math.PI + d) % (Math.PI * 2) - Math.PI * 2) % (Math.PI * 2) + Math.PI;
    }

    public static double makeAnglePositive(double d) {
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        while (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        return d;
    }

    public static double computeAlt(double d, double d2, double d3) {
        return Math.atan2(d3, Math.sqrt(d * d + d2 * d2));
    }

    public static String showRA(double d) {
        double d2 = Math.toDegrees(d);
        double d3 = d2 / 15.0;
        int n = (int)d3;
        double d4 = (d3 - (double)n) * 60.0;
        int n2 = (int)d4;
        double d5 = (d4 - (double)n2) * 60.0;
        return "" + n + "h" + n2 + "m" + d5 + "s";
    }

    public static String showDec(double d) {
        double d2 = Math.toDegrees(d);
        int n = (int)d2;
        double d3 = (d2 - (double)n) * 60.0;
        int n2 = (int)d3;
        double d4 = (d3 - (double)n2) * 60.0;
        return "" + n + "d" + n2 + "'" + d4 + "\"";
    }

    public static void normalize(double[] dArray) {
        Vector3d vector3d = new Vector3d(dArray[0], dArray[1], dArray[2]);
        vector3d.normalise();
        dArray[0] = vector3d.x;
        dArray[1] = vector3d.y;
        dArray[2] = vector3d.z;
    }

    public static double newtonRaphson(double d, DeltaFunction deltaFunction, int n, double d2) {
        if (n > 0) {
            double d3 = deltaFunction.apply(d);
            if (Math.abs(d3 - d) < d2) {
                return d3;
            }
            return AstroUtil.newtonRaphson(d3, deltaFunction, n - 1, d2);
        }
        return d;
    }

    public static String mkString(String[] stringArray, String string) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(string);
        }
        stringBuilder.append(stringArray[stringArray.length - 1]);
        return stringBuilder.toString();
    }

    public static interface DeltaFunction {
        public double apply(double var1);
    }
}

