/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.TokenType;

public final class Token {
    private final int type;
    private int line;
    private int column;
    private final Object value;
    private final String text;
    public static final int AND_EQ = 257;
    public static final int ARROW = 258;
    public static final int CHARACTER = 259;
    public static final int CCOMMENT = 260;
    public static final int CPPCOMMENT = 261;
    public static final int DEC = 262;
    public static final int DIV_EQ = 263;
    public static final int ELLIPSIS = 264;
    public static final int EOF = 265;
    public static final int EQ = 266;
    public static final int GE = 267;
    public static final int HASH = 268;
    public static final int HEADER = 269;
    public static final int IDENTIFIER = 270;
    public static final int INC = 271;
    public static final int NUMBER = 272;
    public static final int LAND = 273;
    public static final int LAND_EQ = 274;
    public static final int LE = 275;
    public static final int LITERAL = 276;
    public static final int LOR = 277;
    public static final int LOR_EQ = 278;
    public static final int LSH = 279;
    public static final int LSH_EQ = 280;
    public static final int MOD_EQ = 281;
    public static final int MULT_EQ = 282;
    public static final int NE = 283;
    public static final int NL = 284;
    public static final int OR_EQ = 285;
    public static final int PASTE = 286;
    public static final int PLUS_EQ = 287;
    public static final int RANGE = 288;
    public static final int RSH = 289;
    public static final int RSH_EQ = 290;
    public static final int SQSTRING = 291;
    public static final int STRING = 292;
    public static final int SUB_EQ = 293;
    public static final int WHITESPACE = 294;
    public static final int XOR_EQ = 295;
    public static final int M_ARG = 296;
    public static final int M_PASTE = 297;
    public static final int M_STRING = 298;
    public static final int P_LINE = 299;
    public static final int INVALID = 300;
    static final Token space = new Token(294, -1, -1, " ");

    public Token(int n, int n2, int n3, String string, Object object) {
        this.type = n;
        this.line = n2;
        this.column = n3;
        this.text = string;
        this.value = object;
    }

    public Token(int n, int n2, int n3, String string) {
        this(n, n2, n3, string, null);
    }

    Token(int n, String string, Object object) {
        this(n, -1, -1, string, object);
    }

    Token(int n, String string) {
        this(n, string, null);
    }

    Token(int n) {
        this(n, TokenType.getTokenText(n));
    }

    public int getType() {
        return this.type;
    }

    void setLocation(int n, int n2) {
        this.line = n;
        this.column = n2;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getText() {
        return this.text;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(Token.getTokenName(this.type));
        if (this.line != -1) {
            stringBuilder.append('@').append(this.line);
            if (this.column != -1) {
                stringBuilder.append(',').append(this.column);
            }
        }
        stringBuilder.append("]:");
        if (this.text != null) {
            stringBuilder.append('\"').append(this.text).append('\"');
        } else if (this.type > 3 && this.type < 256) {
            stringBuilder.append((char)this.type);
        } else {
            stringBuilder.append('<').append(this.type).append('>');
        }
        if (this.value != null) {
            stringBuilder.append('=').append(this.value);
        }
        return stringBuilder.toString();
    }

    public static String getTokenName(int n) {
        return TokenType.getTokenName(n);
    }
}

