/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.cgram.types.IntType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeComparator;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class EnumType
extends IntType
implements Cloneable {
    private final IntType underlyingType;
    private ArrayList<Enumerator> enums;

    public EnumType(String string) {
        super(string, SizeThunk.LONG, false, 1);
        this.underlyingType = new IntType(string, SizeThunk.LONG, false, 1);
    }

    public EnumType(String string, SizeThunk sizeThunk, ASTLocusTag aSTLocusTag) {
        super(string, sizeThunk, false, 1, aSTLocusTag);
        this.underlyingType = new IntType(string, sizeThunk, false, 1, aSTLocusTag);
    }

    private EnumType(EnumType enumType, int n, ASTLocusTag aSTLocusTag) {
        super(enumType, n, aSTLocusTag);
        this.underlyingType = enumType.underlyingType;
        if (null != enumType.enums) {
            this.enums = new ArrayList<Enumerator>(enumType.enums);
        }
    }

    @Override
    Type newVariantImpl(boolean bl, int n, ASTLocusTag aSTLocusTag) {
        return new EnumType(this, n, aSTLocusTag);
    }

    @Override
    protected int hashCodeImpl() {
        int n = super.hashCodeImpl();
        n = (n << 5) - n + this.underlyingType.hashCode();
        return (n << 5) - n + TypeComparator.listsHashCode(this.enums);
    }

    @Override
    protected boolean equalsImpl(Type type) {
        EnumType enumType = (EnumType)type;
        return super.equalsImpl(type) && this.underlyingType.equals(enumType.underlyingType) && TypeComparator.listsEqual(this.enums, enumType.enums);
    }

    @Override
    protected int hashCodeSemanticsImpl() {
        int n = super.hashCodeSemanticsImpl();
        n = (n << 5) - n + this.underlyingType.hashCodeSemantics();
        return (n << 5) - n + TypeComparator.listsHashCodeSemantics(this.enums);
    }

    @Override
    protected boolean equalSemanticsImpl(Type type) {
        EnumType enumType = (EnumType)type;
        return super.equalSemanticsImpl(type) && this.underlyingType.equalSemantics(enumType.underlyingType) && TypeComparator.listsEqualSemantics(this.enums, enumType.enums);
    }

    @Override
    public EnumType asEnum() {
        return this;
    }

    public Type getUnderlyingType() {
        return this.underlyingType;
    }

    public void addEnum(String string, Enumerator enumerator) {
        if (this.enums == null) {
            this.enums = new ArrayList();
        }
        this.enums.add(enumerator);
        this.clearCache();
    }

    public int getNumEnumerates() {
        return this.enums.size();
    }

    public Enumerator getEnum(int n) {
        return this.enums.get(n);
    }

    public Enumerator getEnum(String string) {
        for (int i = 0; i < this.enums.size(); ++i) {
            Enumerator enumerator = this.enums.get(i);
            if (!enumerator.getName().equals(string)) continue;
            return enumerator;
        }
        throw new NoSuchElementException("No enumerate named \"" + string + "\" in EnumType \"" + this.getName() + "\"");
    }

    public boolean containsEnumerate(String string) {
        for (int i = 0; i < this.enums.size(); ++i) {
            if (!this.enums.get(i).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean removeEnumerate(String string) {
        for (int i = 0; i < this.enums.size(); ++i) {
            Enumerator enumerator = this.enums.get(i);
            if (!enumerator.getName().equals(string)) continue;
            this.enums.remove(enumerator);
            this.clearCache();
            return true;
        }
        return false;
    }

    public StringBuilder appendEnums(StringBuilder stringBuilder, boolean bl) {
        for (int i = 0; i < this.enums.size(); ++i) {
            stringBuilder.append(this.enums.get(i)).append(", ");
            if (!bl) continue;
            stringBuilder.append(String.format("%n", new Object[0]));
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    @Override
    public void visit(TypeVisitor typeVisitor) {
        super.visit(typeVisitor);
        this.underlyingType.visit(typeVisitor);
    }

    public static class Enumerator
    implements TypeComparator.SemanticEqualityOp {
        private final String name;
        private final String expr;
        private final ConstantDefinition.CNumber number;

        public Enumerator(String string, long l) {
            this.name = string;
            this.number = new ConstantDefinition.CNumber(false, false, l);
            this.expr = this.number.toJavaString();
        }

        public Enumerator(String string, ConstantDefinition.CNumber cNumber) {
            this.name = string;
            this.number = cNumber;
            this.expr = this.number.toJavaString();
        }

        public Enumerator(String string, String string2) {
            this.name = string;
            this.expr = string2;
            this.number = ConstantDefinition.decodeIntegerNumber(string2);
        }

        public String getName() {
            return this.name;
        }

        public String getExpr() {
            return this.expr;
        }

        public ConstantDefinition.CNumber getNumber() {
            return this.number;
        }

        public boolean hasNumber() {
            return null != this.number;
        }

        public int hashCode() {
            int n = this.name.hashCode();
            return (n << 5) - n + this.expr.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Enumerator)) {
                return false;
            }
            Enumerator enumerator = (Enumerator)object;
            return this.name.equals(enumerator.name) && this.expr.equals(enumerator.expr);
        }

        @Override
        public int hashCodeSemantics() {
            return this.hashCode();
        }

        @Override
        public boolean equalSemantics(TypeComparator.SemanticEqualityOp semanticEqualityOp) {
            return this.equals(semanticEqualityOp);
        }

        public String toString() {
            return "[" + this.name + " = [" + this.expr + ", " + this.number + "]";
        }
    }
}

