/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.gluegen.CommentEmitter;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.GlueGenException;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaEmitter;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.Type;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.List;

public class CMethodBindingEmitter
extends FunctionEmitter {
    protected static final CommentEmitter defaultCommentEmitter = new DefaultCommentEmitter();
    protected static final String arrayResLength = "_array_res_length";
    protected static final String arrayRes = "_array_res";
    protected static final String arrayIdx = "_array_idx";
    protected final Logging.LoggerIf LOG = Logging.getLogger(CMethodBindingEmitter.class.getPackage().getName(), CMethodBindingEmitter.class.getSimpleName());
    protected MethodBinding binding;
    private final String packageName;
    private final String className;
    private final boolean isOverloadedBinding;
    private final boolean isJavaMethodStatic;
    protected boolean forImplementingMethodCall;
    protected boolean forIndirectBufferAndArrayImplementation;
    private List<String> temporaryCVariableDeclarations;
    private List<String> temporaryCVariableAssignments;
    private MessageFormat returnValueCapacityExpression = null;
    private MessageFormat returnValueLengthExpression = null;
    protected static final String STRING_CHARS_PREFIX = "_strchars_";
    protected MachineDataInfo machDesc;
    private boolean isCStructFunctionPointer = false;

    public CMethodBindingEmitter(MethodBinding methodBinding, PrintWriter printWriter, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, MachineDataInfo machineDataInfo, JavaConfiguration javaConfiguration) {
        super(printWriter, false, javaConfiguration);
        assert (methodBinding != null);
        assert (string2 != null);
        assert (string != null);
        this.binding = methodBinding;
        this.packageName = string;
        this.className = string2;
        this.isOverloadedBinding = bl;
        this.isJavaMethodStatic = bl2;
        this.forImplementingMethodCall = bl3;
        this.forIndirectBufferAndArrayImplementation = bl4;
        this.machDesc = machineDataInfo;
        this.setCommentEmitter(defaultCommentEmitter);
    }

    public final MethodBinding getBinding() {
        return this.binding;
    }

    @Override
    public String getInterfaceName() {
        return this.binding.getInterfaceName();
    }

    @Override
    public String getImplName() {
        return this.binding.getImplName();
    }

    @Override
    public String getNativeName() {
        return this.binding.getNativeName();
    }

    @Override
    public FunctionSymbol getCSymbol() {
        return this.binding.getCSymbol();
    }

    public final MessageFormat getReturnValueCapacityExpression() {
        return this.returnValueCapacityExpression;
    }

    public final void setReturnValueCapacityExpression(MessageFormat messageFormat) {
        this.returnValueCapacityExpression = messageFormat;
        if (!this.binding.getJavaReturnType().isNIOBuffer() && !this.binding.getJavaReturnType().isCompoundTypeWrapper()) {
            throw new IllegalArgumentException("Cannot specify return value capacity for a method that does not return java.nio.Buffer or a compound type wrapper: \"" + this.binding + "\"");
        }
    }

    public final MessageFormat getReturnValueLengthExpression() {
        return this.returnValueLengthExpression;
    }

    public final void setReturnValueLengthExpression(MessageFormat messageFormat) {
        this.returnValueLengthExpression = messageFormat;
        if (!this.binding.getJavaReturnType().isArray() && !this.binding.getJavaReturnType().isArrayOfCompoundTypeWrappers()) {
            throw new IllegalArgumentException("Cannot specify return value length for a method that does not return an array: \"" + this.binding + "\"");
        }
    }

    public final List<String> getTemporaryCVariableDeclarations() {
        return this.temporaryCVariableDeclarations;
    }

    public final void setTemporaryCVariableDeclarations(List<String> list) {
        this.temporaryCVariableDeclarations = list;
    }

    public final List<String> getTemporaryCVariableAssignments() {
        return this.temporaryCVariableAssignments;
    }

    public final void setTemporaryCVariableAssignments(List<String> list) {
        this.temporaryCVariableAssignments = list;
    }

    public String getJavaPackageName() {
        return this.packageName;
    }

    public String getJavaClassName() {
        return this.className;
    }

    public final boolean getIsOverloadedBinding() {
        return this.isOverloadedBinding;
    }

    public final boolean getIsJavaMethodStatic() {
        return this.isJavaMethodStatic;
    }

    public final boolean forIndirectBufferAndArrayImplementation() {
        return this.forIndirectBufferAndArrayImplementation;
    }

    public final MachineDataInfo getMachineDataInfo() {
        return this.machDesc;
    }

    @Override
    protected void emitReturnType(PrintWriter printWriter) {
        printWriter.print("JNIEXPORT ");
        printWriter.print(this.binding.getJavaReturnType().jniTypeName());
        printWriter.print(" JNICALL");
    }

    @Override
    protected void emitName(PrintWriter printWriter) {
        printWriter.println();
        printWriter.print(JavaEmitter.getJNIMethodNamePrefix(this.getJavaPackageName(), this.getJavaClassName()));
        printWriter.print("_");
        if (this.isOverloadedBinding) {
            printWriter.print(this.jniMangle(this.binding));
        } else {
            printWriter.print(JavaEmitter.jniMangle(this.getImplName()));
        }
    }

    protected String getImplSuffix() {
        if (this.forImplementingMethodCall) {
            if (this.forIndirectBufferAndArrayImplementation) {
                return "1";
            }
            return "0";
        }
        return "";
    }

    @Override
    protected int emitArguments(PrintWriter printWriter) {
        printWriter.print("JNIEnv *env, ");
        int n = 1;
        if (this.isJavaMethodStatic && !this.binding.hasContainingType()) {
            printWriter.print("jclass");
        } else {
            printWriter.print("jobject");
        }
        printWriter.print(" _unused");
        ++n;
        if (this.binding.hasContainingType()) {
            printWriter.print(", jobject " + JavaMethodBindingEmitter.javaThisArgumentName());
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                assert (this.binding.getNumArguments() == 1);
                continue;
            }
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            printWriter.print(", ");
            printWriter.print(javaType.jniTypeName());
            printWriter.print(" ");
            printWriter.print(this.binding.getArgumentName(i));
            ++n;
            if (javaType.isPrimitiveArray() || javaType.isNIOBuffer()) {
                printWriter.print(", jint " + this.byteOffsetArgName(i));
                if (!this.forIndirectBufferAndArrayImplementation) continue;
                printWriter.print(", jboolean " + this.isNIOArgName(i));
                continue;
            }
            if (!javaType.isNIOBufferArray()) continue;
            printWriter.print(", jintArray " + this.byteOffsetArrayArgName(i));
        }
        return n;
    }

    @Override
    protected void emitBody(PrintWriter printWriter) {
        printWriter.println(" {");
        this.emitBodyVariableDeclarations(printWriter);
        this.emitBodyUserVariableDeclarations(printWriter);
        this.emitBodyVariablePreCallSetup(printWriter);
        this.emitBodyCallCFunction(printWriter);
        this.emitBodyUserVariableAssignments(printWriter);
        this.emitBodyVariablePostCallCleanup(printWriter);
        this.emitBodyReturnResult(printWriter);
        printWriter.println("}");
        printWriter.println();
    }

    protected void emitBodyVariableDeclarations(PrintWriter printWriter) {
        String string;
        Object object;
        JavaType javaType;
        if (this.binding.hasContainingType()) {
            this.emitPointerDeclaration(printWriter, this.binding.getContainingType(), this.binding.getContainingCType(), CMethodBindingEmitter.cThisArgumentName(), null);
        }
        boolean bl = false;
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (javaType.isArray() || javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper() || javaType.isArrayOfCompoundTypeWrappers()) {
                object = this.binding.getArgumentName(i);
                string = this.pointerConversionArgumentName((String)object);
                boolean bl2 = this.emitPointerDeclaration(printWriter, javaType, this.binding.getCArgumentType(i), string, (String)object);
                if (!bl2 || bl) continue;
                printWriter.println("  jobject _tmpObj;");
                printWriter.println("  int _copyIndex;");
                printWriter.println("  jsize _tmpArrayLen;");
                if (javaType.isNIOBufferArray()) {
                    printWriter.println("  int * _offsetHandle = NULL;");
                }
                bl = true;
                continue;
            }
            if (!javaType.isString()) continue;
            object = this.binding.getCArgumentType(i);
            if (this.isUTF8Type((Type)object)) {
                printWriter.print("  const char* ");
            } else {
                printWriter.print("  jchar* ");
            }
            printWriter.print(STRING_CHARS_PREFIX);
            printWriter.print(this.binding.getArgumentName(i));
            printWriter.println(" = NULL;");
        }
        Type type = this.binding.getCReturnType();
        javaType = this.binding.getJavaReturnType();
        if (!type.isVoid()) {
            printWriter.print("  ");
            printWriter.print(this.binding.getCSymbol().getReturnType().getCName(false));
            printWriter.println(" _res;");
            if (javaType.isNIOByteBufferArray() || javaType.isArrayOfCompoundTypeWrappers()) {
                printWriter.print("  int ");
                printWriter.print(arrayResLength);
                printWriter.println(";");
                printWriter.print("  int ");
                printWriter.print(arrayIdx);
                printWriter.println(";");
                printWriter.print("  jobjectArray ");
                printWriter.print(arrayRes);
                printWriter.println(";");
            } else if (javaType.isArray()) {
                printWriter.print("  int ");
                printWriter.print(arrayResLength);
                printWriter.println(";");
                object = javaType.getJavaClass().getComponentType();
                if (((Class)object).isArray()) {
                    throw new RuntimeException("Multi-dimensional arrays not supported yet");
                }
                string = ((Class)object).getName();
                String string2 = "j" + string + "Array";
                printWriter.print("  ");
                printWriter.print(string2);
                printWriter.print(" ");
                printWriter.print(arrayRes);
                printWriter.println(";");
            }
        }
    }

    protected void emitBodyUserVariableDeclarations(PrintWriter printWriter) {
        if (this.temporaryCVariableDeclarations != null) {
            for (String string : this.temporaryCVariableDeclarations) {
                printWriter.print("  ");
                printWriter.println(string);
            }
        }
    }

    protected boolean isUTF8Type(Type type) {
        while (!type.isInt() && !type.isVoid()) {
            PointerType pointerType = type.asPointer();
            if (pointerType != null) {
                type = pointerType.getTargetType();
                continue;
            }
            ArrayType arrayType = type.asArray();
            if (arrayType == null) {
                throw new IllegalArgumentException("Type " + type + " should have been a pointer or array type");
            }
            type = arrayType.getElementType();
        }
        if (type.isVoid()) {
            return true;
        }
        if (!type.isInt()) {
            throw new IllegalArgumentException("Type " + type + " should have been a one- or two-dimensional integer pointer or array type");
        }
        if (type.getSize(this.machDesc) != 1L && type.getSize(this.machDesc) != 2L) {
            throw new IllegalArgumentException("Type " + type + " should have been a one- or two-dimensional pointer to char or short");
        }
        return type.getSize(this.machDesc) == 1L;
    }

    protected void emitBodyVariablePreCallSetup(PrintWriter printWriter) {
        if (this.binding.hasContainingType()) {
            this.emitPointerConversion(printWriter, this.binding, this.binding.getContainingType(), this.binding.getContainingCType(), JavaMethodBindingEmitter.javaThisArgumentName(), CMethodBindingEmitter.cThisArgumentName(), null);
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            String string = this.binding.getArgumentName(i);
            if (javaType.isCompoundTypeWrapper() || javaType.isNIOBuffer() && !this.forIndirectBufferAndArrayImplementation) {
                this.emitPointerConversion(printWriter, this.binding, javaType, this.binding.getCArgumentType(i), string, this.pointerConversionArgumentName(string), this.byteOffsetArgName(i));
                continue;
            }
            if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers() || javaType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation) {
                boolean bl = this.javaArgTypeNeedsDataCopy(javaType);
                printWriter.println("  if ( NULL != " + string + " ) {");
                Type type = this.binding.getCArgumentType(i);
                String string2 = type.getCName();
                String string3 = this.pointerConversionArgumentName(string);
                if (!bl) {
                    printWriter.print("    ");
                    printWriter.print(string3);
                    printWriter.print(" = (");
                    if (javaType.isStringArray()) {
                        string2 = "jstring *";
                    }
                    printWriter.print(string2);
                    printWriter.print(") ( JNI_TRUE == " + this.isNIOArgName(i) + " ? ");
                    printWriter.print(" (*env)->GetDirectBufferAddress(env, " + string + ") : ");
                    printWriter.print(" (*env)->GetPrimitiveArrayCritical(env, " + string + ", NULL) );");
                } else {
                    Type type2;
                    Type type3;
                    if (!type.isBaseTypeConst() && !javaType.isArrayOfCompoundTypeWrappers()) {
                        throw new GlueGenException("Cannot copy data for ptr-to-ptr arg type \"" + type.getDebugString() + "\": support for non-const ptr-to-ptr types not implemented: " + this.binding, this.binding.getCSymbol().getASTLocusTag());
                    }
                    printWriter.println();
                    printWriter.println("    /* Copy contents of " + string + " into " + string3 + "_copy */");
                    printWriter.print("    ");
                    printWriter.print("_tmpArrayLen");
                    printWriter.print(" = (*env)->GetArrayLength(env, ");
                    printWriter.print(string);
                    printWriter.println(");");
                    int n = 0;
                    if (type.isPointer()) {
                        type3 = type.asPointer().getTargetType();
                        if (type3.isPointer()) {
                            type2 = type3.asPointer().getTargetType();
                            if (type2.isPointer()) {
                                n = 1;
                            }
                            if (type.pointerDepth() != 2) {
                                n = 2;
                            }
                        } else {
                            type2 = null;
                            if (type.pointerDepth() != 1) {
                                n = 10;
                            }
                        }
                    } else if (type.isArray()) {
                        type3 = type.asArray().getBaseElementType();
                        type2 = null;
                    } else {
                        type3 = null;
                        type2 = null;
                        n = 100;
                    }
                    if (0 < n) {
                        throw new GlueGenException("Could not copy data for type \"" + type.getDebugString() + "\"; currently only pointer- and array-types are supported. (error " + n + "): " + this.binding, this.binding.getCSymbol().getASTLocusTag());
                    }
                    this.emitMalloc(printWriter, string3 + "_copy", type3.getCName(), type.isBaseTypeConst(), "_tmpArrayLen", "Could not allocate buffer for copying data in argument \\\"" + string + "\\\"");
                    if (javaType.isNIOBufferArray()) {
                        printWriter.println("    _offsetHandle = (int *) (*env)->GetPrimitiveArrayCritical(env, " + this.byteOffsetArrayArgName(i) + ", NULL);");
                    }
                    printWriter.println("    for (_copyIndex = 0; _copyIndex < _tmpArrayLen; ++_copyIndex) {");
                    printWriter.println("      /* get each element of the array argument \"" + string + "\" */");
                    printWriter.print("      _tmpObj = (*env)->GetObjectArrayElement(env, ");
                    printWriter.print(string);
                    printWriter.println(", _copyIndex);");
                    if (javaType.isStringArray()) {
                        printWriter.print("  ");
                        this.emitGetStringChars(printWriter, "(jstring) _tmpObj", string3 + "_copy[_copyIndex]", this.isUTF8Type(type), true);
                    } else if (javaType.isNIOBufferArray()) {
                        this.emitGetDirectBufferAddress(printWriter, "_tmpObj", type3.getCName(), string3 + "_copy[_copyIndex]", true, "_offsetHandle[_copyIndex]", true);
                    } else if (javaType.isArrayOfCompoundTypeWrappers()) {
                        this.emitGetDirectBufferAddress(printWriter, "_tmpObj", type3.getCName(), "(" + string3 + "_copy + _copyIndex)", false, null, true);
                    } else {
                        if (null == type2) {
                            throw new GlueGenException("XXX: Type " + type.getDebugString() + " not properly handled as ptr-to-ptr: " + this.binding, this.binding.getCSymbol().getASTLocusTag());
                        }
                        printWriter.print("      ");
                        this.emitMalloc(printWriter, string3 + "_copy[_copyIndex]", type2.getCName(), type.isBaseTypeConst(), "(*env)->GetArrayLength(env, _tmpObj)", "Could not allocate buffer during copying of data in argument \\\"" + string + "\\\"");
                        throw new GlueGenException("Cannot yet handle type \"" + type.getDebugString() + "\"; need to add support for copying ptr-to-ptr-to-primitiveType subarrays: " + this.binding, this.binding.getCSymbol().getASTLocusTag());
                    }
                    printWriter.println("    }");
                    if (javaType.isNIOBufferArray()) {
                        printWriter.println("    (*env)->ReleasePrimitiveArrayCritical(env, " + this.byteOffsetArrayArgName(i) + ", _offsetHandle, JNI_ABORT);");
                    }
                    printWriter.println();
                }
                printWriter.println("  }");
                continue;
            }
            if (!javaType.isString()) continue;
            this.emitGetStringChars(printWriter, string, STRING_CHARS_PREFIX + string, this.isUTF8Type(this.binding.getCArgumentType(i)), false);
        }
    }

    protected void emitBodyVariablePostCallCleanup(PrintWriter printWriter) {
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            Type type = this.binding.getCArgumentType(i);
            String string = this.binding.getArgumentName(i);
            if (javaType.isArray() || javaType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation || javaType.isArrayOfCompoundTypeWrappers()) {
                boolean bl = this.javaArgTypeNeedsDataCopy(javaType);
                String string2 = this.pointerConversionArgumentName(string);
                if (!bl) {
                    printWriter.println("  if ( JNI_FALSE == " + this.isNIOArgName(i) + " && NULL != " + string + " ) {");
                    String string3 = type.isBaseTypeConst() ? "JNI_ABORT" : "0";
                    printWriter.print("    (*env)->ReleasePrimitiveArrayCritical(env, " + string + ", " + string2 + ", " + string3 + ");");
                } else {
                    printWriter.println("  if ( NULL != " + string + " ) {");
                    if (!type.isBaseTypeConst()) {
                        if (javaType.isArrayOfCompoundTypeWrappers()) {
                            printWriter.println("    _tmpArrayLen = (*env)->GetArrayLength(env, " + string + ");");
                            printWriter.println("    for (_copyIndex = 0; _copyIndex < _tmpArrayLen; ++_copyIndex) {");
                            printWriter.println("      _tmpObj = (*env)->GetObjectArrayElement(env, " + string + ", _copyIndex);");
                            this.emitReturnDirectBufferAddress(printWriter, "_tmpObj", type.asArray().getBaseElementType().getCName(), "(" + string2 + "_copy + _copyIndex)", false, null);
                            printWriter.println("    }");
                        } else {
                            throw new GlueGenException("Cannot clean up copied data for ptr-to-ptr arg type \"" + type.getDebugString() + "\": support for cleaning up most non-const ptr-to-ptr types not implemented.", this.binding.getCSymbol().getASTLocusTag());
                        }
                    }
                    printWriter.println("    /* Clean up " + string2 + "_copy */");
                    if (!javaType.isNIOBufferArray() && !javaType.isArrayOfCompoundTypeWrappers()) {
                        printWriter.print("    ");
                        printWriter.print("_tmpArrayLen");
                        printWriter.print(" = (*env)->GetArrayLength(env, ");
                        printWriter.print(string);
                        printWriter.println(");");
                        PointerType pointerType = type.asPointer();
                        if (pointerType == null) {
                            throw new GlueGenException("Could not copy data for type \"" + type.getDebugString() + "\"; currently only pointer types supported.", this.binding.getCSymbol().getASTLocusTag());
                        }
                        printWriter.println("    for (_copyIndex = 0; _copyIndex < _tmpArrayLen; ++_copyIndex) {");
                        printWriter.println("      /* free each element of " + string2 + "_copy */");
                        printWriter.print("      _tmpObj = (*env)->GetObjectArrayElement(env, ");
                        printWriter.print(string);
                        printWriter.println(", _copyIndex);");
                        if (!javaType.isStringArray()) {
                            throw new GlueGenException("Cannot yet handle type \"" + type.getDebugString() + "\"; need to add support for cleaning up copied ptr-to-ptr-to-primitiveType subarrays", this.binding.getCSymbol().getASTLocusTag());
                        }
                        printWriter.print("     (*env)->ReleaseStringUTFChars(env, ");
                        printWriter.print("(jstring) _tmpObj");
                        printWriter.print(", ");
                        printWriter.print(string2 + "_copy[_copyIndex]");
                        printWriter.println(");");
                        printWriter.println("    }");
                    }
                    printWriter.print("    free((void*) ");
                    printWriter.print(string2 + "_copy");
                    printWriter.println(");");
                }
                printWriter.println("  }");
                continue;
            }
            if (!javaType.isString()) continue;
            printWriter.println("  if ( NULL != " + string + " ) {");
            if (this.isUTF8Type(type)) {
                printWriter.print("    (*env)->ReleaseStringUTFChars(env, ");
                printWriter.print(string);
                printWriter.print(", _strchars_");
                printWriter.print(string);
                printWriter.println(");");
            } else {
                printWriter.println("    free((void*) _strchars_" + string + ");");
            }
            printWriter.println("  }");
        }
    }

    protected int emitBodyPassCArguments(PrintWriter printWriter) {
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType;
            if (i != 0) {
                printWriter.print(", ");
            }
            if ((javaType = this.binding.getJavaArgumentType(i)).isVoid()) {
                assert (this.binding.getNumArguments() == 1);
                continue;
            }
            if (javaType.isJNIEnv()) {
                printWriter.print("env");
                continue;
            }
            if (this.binding.isArgumentThisPointer(i)) {
                printWriter.print(CMethodBindingEmitter.cThisArgumentName());
                continue;
            }
            printWriter.print("(");
            Type type = this.binding.getCArgumentType(i);
            boolean bl = this.javaArgTypeNeedsDataCopy(javaType);
            boolean bl2 = !bl && (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers() || javaType.isNIOBuffer() && this.forIndirectBufferAndArrayImplementation);
            printWriter.print(type.getCName(true));
            printWriter.print(") ");
            if (type.isPointer() && javaType.isPrimitive()) {
                printWriter.print("(intptr_t) ");
            }
            if (javaType.isArray() || javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper() || javaType.isArrayOfCompoundTypeWrappers()) {
                if (bl2) {
                    printWriter.print("(((char *) ");
                } else if (!type.isPointer() && javaType.isCompoundTypeWrapper()) {
                    printWriter.print("*");
                }
                printWriter.print(this.pointerConversionArgumentName(this.binding.getArgumentName(i)));
                if (bl) {
                    printWriter.print("_copy");
                }
                if (!bl2) continue;
                printWriter.print(") + " + this.byteOffsetArgName(i) + ")");
                continue;
            }
            if (javaType.isString()) {
                printWriter.print(STRING_CHARS_PREFIX);
            }
            printWriter.print(this.binding.getArgumentName(i));
        }
        return this.binding.getNumArguments();
    }

    protected void setIsCStructFunctionPointer(boolean bl) {
        this.isCStructFunctionPointer = bl;
    }

    protected void emitBodyCallCFunction(PrintWriter printWriter) {
        printWriter.print("  ");
        Type type = this.binding.getCReturnType();
        if (!type.isVoid()) {
            printWriter.print("_res = (");
            printWriter.print(type.getCName(false));
            printWriter.print(") ");
        }
        if (this.isCStructFunctionPointer && this.binding.hasContainingType()) {
            printWriter.print(CMethodBindingEmitter.cThisArgumentName() + "->");
        }
        printWriter.print(this.getNativeName());
        printWriter.print("(");
        this.emitBodyPassCArguments(printWriter);
        printWriter.println(");");
    }

    protected void emitBodyUserVariableAssignments(PrintWriter printWriter) {
        if (this.temporaryCVariableAssignments != null) {
            for (String string : this.temporaryCVariableAssignments) {
                printWriter.print("  ");
                printWriter.println(string);
            }
        }
    }

    protected void emitBodyReturnResult(PrintWriter printWriter) {
        Type type = this.binding.getCReturnType();
        if (!type.isVoid()) {
            JavaType javaType = this.binding.getJavaReturnType();
            if (javaType.isPrimitive()) {
                printWriter.print("  return ");
                if (type.isPointer()) {
                    printWriter.print("(" + javaType.jniTypeName() + ") (intptr_t) ");
                }
                printWriter.println("_res;");
            } else if (!type.isPointer() && javaType.isCompoundTypeWrapper()) {
                String string = this.returnValueCapacityExpression != null ? this.returnValueCapacityExpression.format(this.argumentNameArray()) : "sizeof(" + type.getCName() + ")";
                printWriter.println("  return JVMUtil_NewDirectByteBufferCopy(env, &_res, " + string + ");");
            } else if (javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper()) {
                printWriter.println("  if (NULL == _res) return NULL;");
                printWriter.print("  return (*env)->NewDirectByteBuffer(env, (void *)_res, ");
                if (this.returnValueCapacityExpression != null) {
                    printWriter.println(this.returnValueCapacityExpression.format(this.argumentNameArray()) + ");");
                } else {
                    Type type2 = type.isPointer() ? type.getTargetType() : null;
                    int n = 0;
                    if (1 == type.pointerDepth() && null != type2) {
                        if (type2.isCompound()) {
                            if (!type2.isAnon() && type2.asCompound().getNumFields() > 0) {
                                if (type2.getSize() == null) {
                                    throw new GlueGenException("Error emitting code for compound return type for function \"" + this.binding + "\": " + "Structs to be emitted should have been laid out by this point " + "(type " + type2.getCName() + " / " + type2.getDebugString() + " was not) for " + this.binding.getCSymbol(), this.binding.getCSymbol().getASTLocusTag());
                                }
                                printWriter.println("sizeof(" + type2.getCName() + ") );");
                                n = 10;
                            } else if (type2.asCompound().getNumFields() == 0) {
                                printWriter.println("sizeof(" + type.getCName() + ") );");
                                n = 11;
                            }
                        }
                        if (0 == n) {
                            if (type2.isPrimitive()) {
                                printWriter.println("sizeof(" + type2.getCName() + ") );");
                                n = 20;
                            } else if (type2.isVoid()) {
                                printWriter.println("sizeof(" + type.getCName() + ") );");
                                n = 21;
                            }
                        }
                    }
                    if (0 == n) {
                        if (null != this.cfg.typeInfo(type)) {
                            printWriter.println("sizeof(" + type.getCName() + ") );");
                            n = 88;
                        } else {
                            printWriter.println("sizeof(" + type.getCName() + ") ); // WARNING: " + "Assumed return size of equivalent C return type");
                            n = 99;
                            this.LOG.warning(this.binding.getCSymbol().getASTLocusTag(), "No capacity specified for java.nio.Buffer return value for function \"" + this.binding.getName() + "\". " + "Assumed return size of equivalent C return type" + " (sizeof(" + type.getCName() + ")): " + this.binding);
                        }
                    }
                    printWriter.println("  /** ");
                    printWriter.println("   * mode: " + n);
                    printWriter.println("   * cReturnType: " + type.getDebugString());
                    printWriter.println("   * cReturnTargetType: " + type2.getDebugString());
                    printWriter.println("   * javaReturnType: " + javaType.getDebugString());
                    printWriter.println("   */");
                }
            } else if (javaType.isString()) {
                printWriter.println("  if (NULL == _res) return NULL;");
                printWriter.println("  return (*env)->NewStringUTF(env, (const char *)_res);");
            } else if (javaType.isArrayOfCompoundTypeWrappers() || javaType.isArray() && javaType.isNIOByteBufferArray()) {
                printWriter.println("  if (NULL == _res) return NULL;");
                if (this.returnValueLengthExpression == null) {
                    throw new GlueGenException("Error while generating C code: no length specified for array returned from function " + this.binding, this.binding.getCSymbol().getASTLocusTag());
                }
                printWriter.println("  _array_res_length = " + this.returnValueLengthExpression.format(this.argumentNameArray()) + ";");
                printWriter.println("  _array_res = (*env)->NewObjectArray(env, _array_res_length, (*env)->FindClass(env, \"java/nio/ByteBuffer\"), NULL);");
                printWriter.println("  for (_array_idx = 0; _array_idx < _array_res_length; _array_idx++) {");
                Type type3 = this.binding.getCSymbol().getReturnType();
                Type type4 = type3.isPointer() ? type3.asPointer().getTargetType() : type3.asArray().getBaseElementType();
                printWriter.println("    (*env)->SetObjectArrayElement(env, _array_res, _array_idx, (*env)->NewDirectByteBuffer(env, (void *)_res[_array_idx], sizeof(" + type4.getCName() + ")));");
                printWriter.println("  }");
                printWriter.println("  return _array_res;");
            } else {
                if (javaType.isArray()) {
                    throw new GlueGenException("Could not emit native code for function \"" + this.binding + "\": array return values for non-char types not implemented yet, for " + this.binding, this.binding.getCSymbol().getASTLocusTag());
                }
                throw new GlueGenException("Unhandled return type: " + javaType.getDebugString() + " for " + this.binding, this.binding.getCSymbol().getReturnType().getASTLocusTag());
            }
        }
    }

    protected static String cThisArgumentName() {
        return "this0";
    }

    protected String jniMangle(MethodBinding methodBinding) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JavaEmitter.jniMangle(this.getImplName()));
        stringBuilder.append(this.getImplSuffix());
        stringBuilder.append("__");
        if (methodBinding.hasContainingType()) {
            this.jniMangle(ByteBuffer.class, stringBuilder, true);
        }
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            Object[] objectArray;
            if (methodBinding.isArgumentThisPointer(i)) continue;
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                if (i == 0 && methodBinding.getNumArguments() <= 1) continue;
                throw new GlueGenException("Saw illegal \"void\" argument while emitting arg " + i + " of " + methodBinding, methodBinding.getCArgumentType(i).getASTLocusTag());
            }
            Class<?> clazz = javaType.getJavaClass();
            if (clazz != null) {
                this.jniMangle(clazz, stringBuilder, false);
                if (javaType.isNIOBuffer()) {
                    this.jniMangle(Integer.TYPE, stringBuilder, false);
                    if (this.forIndirectBufferAndArrayImplementation) {
                        this.jniMangle(Boolean.TYPE, stringBuilder, false);
                    }
                } else if (javaType.isNIOBufferArray()) {
                    objectArray = new int[0];
                    clazz = objectArray.getClass();
                    this.jniMangle(clazz, stringBuilder, true);
                }
                if (!javaType.isPrimitiveArray()) continue;
                this.jniMangle(Integer.TYPE, stringBuilder, false);
                continue;
            }
            if (javaType.isCompoundTypeWrapper()) {
                this.jniMangle(ByteBuffer.class, stringBuilder, true);
                continue;
            }
            if (javaType.isArrayOfCompoundTypeWrappers()) {
                objectArray = new ByteBuffer[]{};
                this.jniMangle(objectArray.getClass(), stringBuilder, true);
                continue;
            }
            if (javaType.isJNIEnv()) continue;
            throw new GlueGenException("Unknown kind of JavaType: arg " + i + ", name=" + javaType.getName() + " of " + methodBinding, methodBinding.getCArgumentType(i).getASTLocusTag());
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void jniMangle(Class<?> clazz, StringBuilder stringBuilder, boolean bl) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                stringBuilder.append("Z");
                return;
            } else if (clazz == Byte.TYPE) {
                stringBuilder.append("B");
                return;
            } else if (clazz == Character.TYPE) {
                stringBuilder.append("C");
                return;
            } else if (clazz == Short.TYPE) {
                stringBuilder.append("S");
                return;
            } else if (clazz == Integer.TYPE) {
                stringBuilder.append("I");
                return;
            } else if (clazz == Long.TYPE) {
                stringBuilder.append("J");
                return;
            } else if (clazz == Float.TYPE) {
                stringBuilder.append("F");
                return;
            } else {
                if (clazz != Double.TYPE) throw new RuntimeException("Illegal primitive type \"" + clazz.getName() + "\"");
                stringBuilder.append("D");
            }
            return;
        } else if (bl) {
            if (clazz.isArray()) {
                stringBuilder.append("_3");
                Class<?> clazz2 = clazz.getComponentType();
                this.jniMangle(clazz2, stringBuilder, clazz2 == ByteBuffer.class);
                return;
            } else {
                stringBuilder.append("L");
                stringBuilder.append(clazz.getName().replace('.', '_'));
                stringBuilder.append("_2");
            }
            return;
        } else if (clazz.isArray()) {
            stringBuilder.append("_3");
            this.jniMangle(clazz.getComponentType(), stringBuilder, false);
            return;
        } else if (clazz == String.class) {
            stringBuilder.append("L");
            stringBuilder.append(clazz.getName().replace('.', '_'));
            stringBuilder.append("_2");
            return;
        } else {
            stringBuilder.append("L");
            stringBuilder.append("java_lang_Object");
            stringBuilder.append("_2");
        }
    }

    private void emitOutOfMemoryCheck(PrintWriter printWriter, String string, String string2) {
        printWriter.println("  if ( NULL == " + string + " ) {");
        printWriter.println("      (*env)->ThrowNew(env, (*env)->FindClass(env, \"java/lang/OutOfMemoryError\"),");
        printWriter.print("                       \"" + string2);
        printWriter.print(" in native dispatcher for \\\"");
        printWriter.print(this.getInterfaceName());
        printWriter.println("\\\"\");");
        printWriter.print("      return");
        if (!this.binding.getJavaReturnType().isVoid()) {
            printWriter.print(" 0");
        }
        printWriter.println(";");
        printWriter.println("    }");
    }

    private void emitMalloc(PrintWriter printWriter, String string, String string2, boolean bl, String string3, String string4) {
        printWriter.print("    ");
        printWriter.print(string);
        printWriter.print(" = (");
        if (bl) {
            printWriter.print("const ");
        }
        printWriter.print(string2);
        printWriter.print(" *) malloc(");
        printWriter.print(string3);
        printWriter.print(" * sizeof(");
        printWriter.print(string2);
        printWriter.println("));");
        this.emitOutOfMemoryCheck(printWriter, string, string4);
    }

    private void emitCalloc(PrintWriter printWriter, String string, String string2, String string3, String string4) {
        printWriter.print("    ");
        printWriter.print(string);
        printWriter.print(" = (");
        printWriter.print(string2);
        printWriter.print(" *) calloc(");
        printWriter.print(string3);
        printWriter.print(", sizeof(");
        printWriter.print(string2);
        printWriter.println("));");
        this.emitOutOfMemoryCheck(printWriter, string, string4);
    }

    private void emitGetStringChars(PrintWriter printWriter, String string, String string2, boolean bl, boolean bl2) {
        printWriter.println("  if ( NULL != " + string + " ) {");
        if (bl) {
            printWriter.print("    ");
            printWriter.print(string2);
            printWriter.print(" = (*env)->GetStringUTFChars(env, ");
            printWriter.print(string);
            printWriter.println(", (jboolean*)NULL);");
            this.emitOutOfMemoryCheck(printWriter, string2, "Failed to get UTF-8 chars for argument \\\"" + string + "\\\"");
        } else {
            this.emitCalloc(printWriter, string2, "jchar", "(*env)->GetStringLength(env, " + string + ") + 1", "Could not allocate temporary buffer for copying string argument \\\"" + string + "\\\"");
            printWriter.println("    (*env)->GetStringRegion(env, " + string + ", 0, (*env)->GetStringLength(env, " + string + "), " + string2 + ");");
        }
        printWriter.print("  }");
        if (bl2) {
            printWriter.print(" else {");
            printWriter.print("      ");
            printWriter.print(string2);
            printWriter.println(" = NULL;");
            printWriter.println("  }");
        } else {
            printWriter.println();
        }
    }

    private void emitGetDirectBufferAddress(PrintWriter printWriter, String string, String string2, String string3, boolean bl, String string4, boolean bl2) {
        printWriter.println("    if ( NULL != " + string + " ) {");
        printWriter.print("    ");
        printWriter.print("    ");
        if (bl) {
            printWriter.print(string3 + " = (" + string2 + ") (((char*) (*env)->GetDirectBufferAddress(env, " + string + "))");
            printWriter.println(" + " + (string4 != null ? string4 : "0") + ");");
        } else {
            printWriter.println("memcpy((void *)" + string3 + ", (*env)->GetDirectBufferAddress(env, " + string + "), sizeof(" + string2 + "));");
        }
        if (bl2) {
            printWriter.println("    } else {");
            printWriter.print("    ");
            printWriter.print("    ");
            if (bl) {
                printWriter.print(string3);
                printWriter.println(" = NULL;");
            } else {
                printWriter.println("memset((void *)" + string3 + ", 0, sizeof(" + string2 + "));");
            }
        }
        printWriter.println("    }");
        printWriter.println();
    }

    private void emitReturnDirectBufferAddress(PrintWriter printWriter, String string, String string2, String string3, boolean bl, String string4) {
        printWriter.print("    ");
        printWriter.print("    ");
        if (bl) {
            printWriter.print("(((char*) (*env)->GetDirectBufferAddress(env, " + string + "))");
            printWriter.println(" + " + (string4 != null ? string4 : "0") + ") = " + string3 + ";");
            throw new RuntimeException("incomplete implementation");
        }
        printWriter.println("memcpy((*env)->GetDirectBufferAddress(env, " + string + "), " + string3 + ", sizeof(" + string2 + "));");
        printWriter.println();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean emitPointerDeclaration(PrintWriter printWriter, JavaType javaType, Type type, String string, String string2) {
        Object object;
        Class<?> clazz;
        String string3 = null;
        boolean bl = false;
        if (javaType.isNIOBuffer()) {
            string3 = type.getCName();
        } else if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers()) {
            bl = this.javaArgTypeNeedsDataCopy(javaType);
            if (javaType.isPrimitiveArray() || javaType.isNIOBufferArray() || javaType.isArrayOfCompoundTypeWrappers()) {
                string3 = type.getCName();
            } else if (!javaType.isStringArray()) {
                clazz = javaType.getJavaClass().getComponentType();
                if (!clazz.isArray()) throw new GlueGenException("Unsupported pointer type: \"" + type.getDebugString() + "\"", type.getASTLocusTag());
                object = clazz.getComponentType();
                if (!((Class)object).isPrimitive()) throw new GlueGenException("Unsupported pointer type: \"" + type.getDebugString() + "\"", type.getASTLocusTag());
                string3 = type.getCName();
            }
        } else {
            string3 = type.getCName();
        }
        printWriter.print("  ");
        if (!bl) {
            printWriter.print(string3);
            if (!type.isPointer() && javaType.isCompoundTypeWrapper()) {
                printWriter.print(" * ");
            } else {
                printWriter.print(" ");
            }
            printWriter.print(string);
            printWriter.println(" = NULL;");
            return bl;
        } else {
            if (javaType.isStringArray()) {
                clazz = "char *";
                object = type.asPointer();
                if (object != null) {
                    clazz = ((PointerType)object).getTargetType().asPointer().getCName();
                }
                if (type.isBaseTypeConst()) {
                    printWriter.print("const ");
                }
                printWriter.print((String)((Object)clazz) + " *");
            } else {
                if (type.isBaseTypeConst()) {
                    printWriter.print("const ");
                }
                printWriter.print(string3);
            }
            printWriter.print(" ");
            printWriter.print(string);
            printWriter.print("_copy = NULL; /* copy of data in ");
            printWriter.print(string2);
            printWriter.println(", laid out according to C memory model */");
        }
        return bl;
    }

    private void emitPointerConversion(PrintWriter printWriter, MethodBinding methodBinding, JavaType javaType, Type type, String string, String string2, String string3) {
        if (javaType.isCompoundTypeWrapper()) {
            string3 = null;
        }
        String string4 = !type.isPointer() && javaType.isCompoundTypeWrapper() ? type.getCName() + " *" : type.getCName();
        this.emitGetDirectBufferAddress(printWriter, string, string4, string2, true, string3, false);
    }

    protected String byteOffsetArgName(int n) {
        return JavaMethodBindingEmitter.byteOffsetArgName(this.binding.getArgumentName(n));
    }

    protected String isNIOArgName(int n) {
        return this.isNIOArgName(this.binding.getArgumentName(n));
    }

    protected String isNIOArgName(String string) {
        return string + "_is_nio";
    }

    protected String byteOffsetArrayArgName(int n) {
        return this.binding.getArgumentName(n) + "_byte_offset_array";
    }

    protected String[] argumentNameArray() {
        String[] stringArray = new String[this.binding.getNumArguments()];
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            stringArray[i] = this.binding.getArgumentName(i);
            if (!this.binding.getJavaArgumentType(i).isPrimitiveArray()) continue;
            stringArray[i] = stringArray[i] + ", " + this.byteOffsetArgName(i);
        }
        return stringArray;
    }

    protected String pointerConversionArgumentName(String string) {
        return "_" + string + "_ptr";
    }

    protected boolean javaArgTypeNeedsDataCopy(JavaType javaType) {
        if (javaType.isArray()) {
            return javaType.isNIOBufferArray() || javaType.isStringArray() || javaType.getJavaClass().getComponentType().isArray();
        }
        return javaType.isArrayOfCompoundTypeWrappers();
    }

    protected static class DefaultCommentEmitter
    implements CommentEmitter {
        protected DefaultCommentEmitter() {
        }

        @Override
        public void emit(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            this.emitBeginning((CMethodBindingEmitter)functionEmitter, printWriter);
            this.emitEnding((CMethodBindingEmitter)functionEmitter, printWriter);
        }

        protected void emitBeginning(CMethodBindingEmitter cMethodBindingEmitter, PrintWriter printWriter) {
            printWriter.println("  Java->C glue code:");
            printWriter.print(" *   Java package: ");
            printWriter.print(cMethodBindingEmitter.getJavaPackageName());
            printWriter.print(".");
            printWriter.println(cMethodBindingEmitter.getJavaClassName());
            printWriter.print(" *    Java method: ");
            MethodBinding methodBinding = cMethodBindingEmitter.getBinding();
            printWriter.println(methodBinding);
            printWriter.println(" *     C function: " + methodBinding.getCSymbol());
        }

        protected void emitEnding(CMethodBindingEmitter cMethodBindingEmitter, PrintWriter printWriter) {
        }
    }
}

